#include "avr/pgmspace.h"
#include <arduino2.h>

#include "sqk_defines.h"
#include "sqk_waveforms.h"
#include "sqk_oscillator.h"
#include "sqk_keyboard.h"
#include "sqk_controls.h"

//LATEST CHANGES:
//- Slowed down the ADSR processing
//- Fixed ADSR overshoot
//- didn't fix volume overflow, switch to Due will fix that (32 bit ints)
//- didn't fix ADSR knob exponential nature, will replace with log pots for final version

//TODO
//- Envelopes need to be per-pair, saves RAM!
//- Check controls, especially detuning has some float/double conversion shit going on
//- Continuous waveform selection
//- Optimize interrupt code!
//- Research PWM for the waveforms
//- Portamento/Glide functionality?

//HARDWARE TODO
//- experiment with adding a simple feedback control to the Crusher, that feeds the signal back to somewhere

void setup() 
{
    //analog 0 - 5: operator 1 vars
    //analog 6 - 11: operator 2 vars

    //pin 8 is gate output
    pinMode(8, OUTPUT);
    digitalWrite(8, HIGH);
    
    //pin 10 is audio output
    pinMode(10, OUTPUT);

    //pins 22 - 31 keyboard scanner
    pinMode(22, OUTPUT);
    pinMode(23, OUTPUT);    
    for(unsigned char i = 24; i < 32; i++)
        pinMode(i, INPUT);

    //pin 32 is the synth mode switch (FM/Add)
    pinMode(32, INPUT_PULLUP);

    //also preset all key bools to false
    for(unsigned char i = 0; i < 49; i++)
        m_keys[i] = false;

    //set knobs to default values
    for(unsigned char i = 0; i < 16; i++)
        knobvals[i] = 0;

    //Set all oscillators to default values    
    for(int c=0;c<NUM_OSCS;++c)
    {
        oscillators[c].m_amplitude = 0;
        oscillators[c].m_wave = oscBtable;
        oscillators[c].m_phase = 0;
        
        oscillators[c].m_gate = false;
        oscillators[c].m_detune = 0;
        oscillators[c].m_attack = 16;
        oscillators[c].m_decay = 16;
        oscillators[c].m_sustain = 63;
        oscillators[c].m_release = 16;
        oscillators[c].m_depth = 63;
        oscillators[c].m_stage = false;
        oscillators[c].m_envlevel = 0;
    }

     for(int c=0;c<NUM_OSCS;c+=2)
    {
        oscillators[c].m_wave = oscAtable;
    }

    // Timer2 Clock Prescaler to : 1
    sbi (TCCR2B, CS20);
    cbi (TCCR2B, CS21);
    cbi (TCCR2B, CS22);
    
    // Timer2 PWM Mode set to Phase Correct PWM
    cbi (TCCR2A, COM2A0);  // clear Compare Match
    sbi (TCCR2A, COM2A1);
    
    sbi (TCCR2A, WGM20);   // Mode 1  / Phase Correct PWM
    cbi (TCCR2A, WGM21);
    cbi (TCCR2B, WGM22);

    cbi (TIMSK0,TOIE0);    // disable Timer0 !!! delay() is now not available
    sbi (TIMSK2,TOIE2);    // enable Timer2 Interrupt    
}

void loop() 
{
    unsigned int lastStep=loopStepsHigh;
    unsigned curStep=loopStepsHigh;
    char timec = 0;
    while(1) 
    {
        lastStep=curStep;
        curStep=loopStepsHigh;
        
        if(lastStep != curStep)
        {
            if(m_seq)
                StepSequencer();
            ScanControls();
            ScanKeys();
            
            for(int c=0;c<NUM_OSCS;++c)
            {
                if(oscillators[c].m_gate) //attack -> decay -> sustain
                {
                    if(!oscillators[c].m_stage) //attack
                    {
                        oscillators[c].m_envlevel += oscillators[c].m_attack*(curStep-lastStep);
                        if(oscillators[c].m_envlevel > 127 || oscillators[c].m_envlevel < 0)
                        {
                            oscillators[c].m_envlevel = 127;
                            oscillators[c].m_stage = true;
                        }
                    }
                    else if(oscillators[c].m_envlevel > oscillators[c].m_sustain) //decay / sustain                           
                        oscillators[c].m_envlevel -= oscillators[c].m_decay*(curStep-lastStep);
                    else
                        oscillators[c].m_envlevel = oscillators[c].m_sustain;
                }
                else
                {
                    if(oscillators[c].m_envlevel > 0)
                        oscillators[c].m_envlevel -= oscillators[c].m_release*(curStep-lastStep);
                    else
                        oscillators[c].m_envlevel = 0;
                }

                oscillators[c].m_amplitude = (oscillators[c].m_envlevel * oscillators[c].m_depth) >> 7;
            }
            
            WAIT_UNTIL_INTERRUPT();
        }
    }
}

ISR(TIMER2_OVF_vect) 
{
    //128*64*8 = 65536
    //Arduino Mega signed integer can only hold 15 bits = -32768 -> 32768
    //so we quickly get an overflow at halfway volume
    //On Arduino Due the integers are 32 bit, instead of 16 so we don't have this issue.
    
    int outValue;

    if(FM)
    {
        oscillators[0].m_phase += oscillators[0].m_freq;
        oscillators[1].m_phase += oscillators[1].m_freq + (oscillators[0].m_wave[oscillators[0].m_phase>>8] * oscillators[0].m_amplitude);
        outValue = oscillators[1].m_wave[oscillators[1].m_phase>>8] * oscillators[1].m_amplitude;    
    
        oscillators[2].m_phase += oscillators[2].m_freq;
        oscillators[3].m_phase += oscillators[3].m_freq + (oscillators[2].m_wave[oscillators[2].m_phase>>8] * oscillators[2].m_amplitude);
        outValue += oscillators[3].m_wave[oscillators[3].m_phase>>8] * oscillators[3].m_amplitude;
    
        oscillators[4].m_phase += oscillators[4].m_freq;
        oscillators[5].m_phase += oscillators[5].m_freq + (oscillators[4].m_wave[oscillators[4].m_phase>>8] * oscillators[4].m_amplitude);
        outValue += oscillators[5].m_wave[oscillators[5].m_phase>>8] * oscillators[5].m_amplitude;    
    
        oscillators[6].m_phase += oscillators[6].m_freq;
        oscillators[7].m_phase += oscillators[7].m_freq + (oscillators[6].m_wave[oscillators[6].m_phase>>8] * oscillators[6].m_amplitude);
        outValue += oscillators[7].m_wave[oscillators[7].m_phase>>8] * oscillators[7].m_amplitude;
    }
    else
    {
        oscillators[0].m_phase += oscillators[0].m_freq;
        outValue = oscillators[0].m_wave[oscillators[0].m_phase>>8] * oscillators[0].m_amplitude;

        oscillators[1].m_phase += oscillators[1].m_freq;
        outValue += oscillators[1].m_wave[oscillators[1].m_phase>>8] * oscillators[1].m_amplitude;

        oscillators[2].m_phase += oscillators[2].m_freq;
        outValue += oscillators[2].m_wave[oscillators[2].m_phase>>8] * oscillators[2].m_amplitude;

        oscillators[3].m_phase += oscillators[3].m_freq;
        outValue += oscillators[3].m_wave[oscillators[3].m_phase>>8] * oscillators[3].m_amplitude;

        oscillators[4].m_phase += oscillators[4].m_freq;
        outValue += oscillators[4].m_wave[oscillators[4].m_phase>>8] * oscillators[4].m_amplitude;

        oscillators[5].m_phase += oscillators[5].m_freq;
        outValue += oscillators[5].m_wave[oscillators[5].m_phase>>8] * oscillators[5].m_amplitude;

        oscillators[6].m_phase += oscillators[6].m_freq;
        outValue += oscillators[6].m_wave[oscillators[6].m_phase>>8] * oscillators[6].m_amplitude;

        oscillators[7].m_phase += oscillators[7].m_freq;
        outValue += oscillators[7].m_wave[oscillators[7].m_phase>>8] * oscillators[7].m_amplitude;
    }
    
    char valOut = ((unsigned int)(outValue)) >> 8;  
    valOut += 128;
    OCR2A = (byte)valOut;
    
    asm
    (
        "inc %[loopSteps]" "\n\t"
        "brbc 1,loopend%=" "\n\t"
        "inc %A[loopStepsHigh]" "\n\t"
        "brbc 1,loopend%=" "\n\t"
        "inc %B[loopStepsHigh]" "\n\t"
        "loopend%=:" "\n\t"
        :[loopSteps] "+a" (loopSteps),[loopStepsHigh] "+a" (loopStepsHigh):
    );   
}

