#ifndef _sqk_keys
#define _sqk_keys

bool m_keys[49];
char m_seqnotes[64];
bool m_seq = true;
char m_seqtimer = 0;
char m_seqcounter = 0;
char m_seqpos = 0;
char m_seqoscpos = 0;

//MIDI PITCHES FOR KEYBOARD
const uint16_t PROGMEM SQK_PITCHS[]=
{
    //C3    C#3     D3     D#3    E3     F3     F#3    G3    G#3     A3     A#3    B3
    0x0112,0x0122,0x0134,0x0146,0x0159,0x016E,0x0184,0x019B,0x01B4,0x01CE,0x01E9,0x0205,
    0x0226,0x0245,0x0268,0x028D,0x02B4,0x02DD,0x0308,0x0336,0x0367,0x039B,0x03D2,0x040C,
    0x044A,0x048B,0x04D0,0x0519,0x0567,0x05B9,0x0610,0x066D,0x06CF,0x0736,0x07A4,0x0816,
    0x0893,0x0916,0x09A0,0x0A33,0x0ACE,0x0B73,0x0C21,0x0CDA,0x0D9D,0x0E6C,0x0F48,0x1031,0x1127
};

void StepSequencer()
{
    //this gets called ~32000/256 = ~125 times per second
    //need an array to iterate through, this array holds the keys currently pressed?

    //120 BPM 4th notes / 60 = 2 4th notes per second
    //so 125/2 = every ~63 calls we play a 4th note
    //so 125/4 = every ~31 calls we play a 8th note, etc

    m_seqtimer++;
    if(m_seqtimer > 62)
    {        
        m_seqtimer = 0;
        m_seqcounter++;
        if(m_seqcounter > m_seqpos)
            m_seqcounter = 0;
            
        oscillators[m_seqoscpos].m_phase = 0;
        oscillators[m_seqoscpos].m_freq = pgm_read_word(&SQK_PITCHS[m_seqnotes[m_seqcounter]]) * oscillators[m_seqoscpos].m_detune;
        oscillators[m_seqoscpos].m_gate = true;

        m_seqoscpos++;
        oscillators[m_seqoscpos].m_phase = 0;
        oscillators[m_seqoscpos].m_freq = pgm_read_word(&SQK_PITCHS[m_seqnotes[m_seqcounter]]) * oscillators[m_seqoscpos].m_detune;
        oscillators[m_seqoscpos].m_gate = true;
        
        m_seqoscpos++;
        if(m_seqoscpos > 7)
        {
            m_seqoscpos = 0;
        }
    }
}

void ScanKeys()
{    
    SET(PORTA,1);
    WAIT_UNTIL_INTERRUPT();
    CLR(PORTA,1);

    bool k_pressed = false;
    
    for(unsigned char i = 0; i < 6; ++i)
    {
        for(unsigned char j = 0; j < 8; ++j)
        {
            char currnote = (i*8)+j;
            
            if(digitalRead2(31-j) == HIGH)
            {
                k_pressed = true;
                if(m_keys[currnote] == false)
                {
                    m_keys[currnote] = true;
                    if(!m_seq)
                    {
                        for (char c = 0; c < NUM_OSCS; c+=2)
                        {
                            if (oscillators[c].m_gate == false)
                            {
                                oscillators[c].m_phase = 0;
                                oscillators[c].m_freq = pgm_read_word(&SQK_PITCHS[currnote]) * oscillators[c].m_detune;
                                oscillators[c].m_gate = true;
                                oscillators[c].m_note = currnote;
    
                                oscillators[c+1].m_phase = 0;
                                oscillators[c+1].m_freq = pgm_read_word(&SQK_PITCHS[currnote]) * oscillators[c+1].m_detune;
                                oscillators[c+1].m_gate = true;
                                oscillators[c+1].m_note = currnote;
                                break;
                            }
                        } 
                    }
                    else
                    {
                        m_seqnotes[m_seqpos] = currnote;     
                        m_seqpos++;       
                        if(m_seqpos > 63)
                            m_seqpos = 63;      
                    }
                }
            }
            else
            {
                if(m_keys[currnote] == true)
                {
                    m_keys[currnote] = false;   
                    if(!m_seq)
                    {
                        for(char c = 0; c < NUM_OSCS; c+=2)
                        {
                            if(oscillators[c].m_note == currnote && oscillators[c].m_gate)
                            {
                                oscillators[c].m_gate = false;
                                oscillators[c].m_stage = false;
                                oscillators[c+1].m_gate = false;
                                oscillators[c+1].m_stage = false;
                                break;
                            }                    
                        }  
                    }
                    else
                    { 
                        m_seqpos--;  
                        if(m_seqpos < 0)
                            m_seqpos = 0;       
                    }             
                }
            }
        }
        
        SET(PORTA,0);
        WAIT_UNTIL_INTERRUPT();
        CLR(PORTA,0);

        if(k_pressed)
            SET(PORTH,5);
        else
            CLR(PORTH,5);
    }
}


#endif
