#ifndef _sqk_waveforms
#define _sqk_waveforms

const PROGMEM char sqk_sine[] = 
{
0, -3, -6, -9, -12, -15, -18, -21, -24, -27, -30, -33, -36, -39, -42, -45, -48, -51, -54, -57, -59, -62, -65, -67, -70, -73, -75, -78, -80, -82, -85, -87, -89, -91, -94, -96, -98, -100, -102, -103, -105, -107, -108, -110, -112, -113, -114, -116, -117, -118, -119, -120, -121, -122, -123, -123, -124, -125, -125, -126, -126, -126, -126, -126, -127, -126, -126, -126, -126, -126, -125, -125, -124, -123, -123, -122, -121, -120, -119, -118, -117, -116, -114, -113, -112, -110, -108, -107, -105, -103, -102, -100, -98, -96, -94, -91, -89, -87, -85, -82, -80, -78, -75, -73, -70, -67, -65, -62, -59, -57, -54, -51, -48, -45, -42, -39, -36, -33, -30, -27, -24, -21, -18, -15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 59, 62, 65, 67, 70, 73, 75, 78, 80, 82, 85, 87, 89, 91, 94, 96, 98, 100, 102, 103, 105, 107, 108, 110, 112, 113, 114, 116, 117, 118, 119, 120, 121, 122, 123, 123, 124, 125, 125, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 125, 125, 124, 123, 123, 122, 121, 120, 119, 118, 117, 116, 114, 113, 112, 110, 108, 107, 105, 103, 102, 100, 98, 96, 94, 91, 89, 87, 85, 82, 80, 78, 75, 73, 70, 67, 65, 62, 59, 57, 54, 51, 48, 45, 42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9, 6, 3
};

const PROGMEM char sqk_tri[] = 
{
-127,-125,-123,-121,-119,-117,-115,-113,-111,-109,-107,-105,-103,-101,-99,-97,
-95,-93,-91,-89,-87,-85,-83,-81,-79,-77,-75,-73,-71,-69,-67,-65,
-63,-61,-59,-57,-55,-53,-51,-49,-47,-45,-43,-41,-39,-37,-35,-33,
-31,-29,-27,-25,-23,-21,-19,-17,-15,-13,-11,-9,-7,-5,-3,-1,
1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,
33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,
65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,
97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,126,
127,126,125,123,121,119,117,115,113,111,109,107,105,103,101,99,
97,95,93,91,89,87,85,83,81,79,77,75,73,71,69,67,
65,63,61,59,57,55,53,51,49,47,45,43,41,39,37,35,
33,31,29,27,25,23,21,19,17,15,13,11,9,7,5,3,
1,-1,-3,-5,-7,-9,-11,-13,-15,-17,-19,-21,-23,-25,-27,-29,
-31,-33,-35,-37,-39,-41,-43,-45,-47,-49,-51,-53,-55,-57,-59,-61,
-63,-65,-67,-69,-71,-73,-75,-77,-79,-81,-83,-85,-87,-89,-91,-93,
-95,-97,-99,-101,-103,-105,-107,-109,-111,-113,-115,-117,-119,-121,-123,-125
};

const PROGMEM char sqk_pulse[] = 
{
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127
};

const PROGMEM char sqk_sqr[] = 
{
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,
-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127 
};

const PROGMEM char sqk_saw[] = 
{
-127,-127,-126,-125,-124,-123,-122,-121,-120,-119,-118,-117,-116,-115,-114,-113,
-112,-111,-110,-109,-108,-107,-106,-105,-104,-103,-102,-101,-100,-99,-98,-97,
-96,-95,-94,-93,-92,-91,-90,-89,-88,-87,-86,-85,-84,-83,-82,-81,
-80,-79,-78,-77,-76,-75,-74,-73,-72,-71,-70,-69,-68,-67,-66,-65,
-64,-63,-62,-61,-60,-59,-58,-57,-56,-55,-54,-53,-52,-51,-50,-49,
-48,-47,-46,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-35,-34,-33,
-32,-31,-30,-29,-28,-27,-26,-25,-24,-23,-22,-21,-20,-19,-18,-17,
-16,-15,-14,-13,-12,-11,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,
48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
};

const PROGMEM char sqk_noise[] = 
{
-62,-72,-92,-98,98,-103,96,-89,-29,-55,98,-8,-118,13,11,-1,76,-8,-116,51,33,-85,-43,-16,-114,-47,-63,-113,109,-39,-127,-59,0,118,70,62,54,85,51,122,60,30,-126,-25,71,-82,-11,64,-95,-110,127,37,-14,-57,51,-4,-47,-80,110,7,-117,89,65,-58,50,-21,33,-113,-22,111,-46,108,112,-57,-111,53,-21,-22,-127,-18,-9,95,88,99,-17,-3,74,2,123,-31,53,-7,91,-80,15,-112,114,14,-115,-55,22,95,21,53,-105,-67,-25,25,13,58,-121,-62,103,87,109,38,-79,-60,-16,-68,-91,90,112,-99,118,87,-61,-36,-40,-39,-30,34,83,-100,-43,-114,-54,-8,-36,-52,71,22,-33,116,9,114,24,-91,-48,-106,-2,-31,103,21,117,44,115,-59,53,97,124,66,120,-44,57,-96,-24,46,32,111,-56,-123,46,-11,97,-70,-12,-89,-81,24,-29,-23,77,42,-40,8,-98,-35,-21,116,61,-41,116,66,-88,22,95,-31,40,-51,-78,28,3,124,92,81,-27,78,65,-16,-116,-73,-126,55,-76,78,17,43,66,-24,117,-38,-76,-10,-37,-47,-56,33,94,-40,107,36,-104,-11,-27,-23,105,-96,68,-25,7,67,6,-69,70,-10,10,5,42,120,-71,-122,-86,113,112,119
};

const PROGMEM char sqk_hammond[] = 
{
0,-1,-3,-5,-7,-9,-10,-12,-13,-14,-15,-16,-17,-17,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-13,-12,-12,-11,-10,-10,-10,-9,-9,-10,-10,-11,-11,-12,-13,-15,-16,-17,-19,-21,-23,-25,-26,-28,-30,-32,-33,-35,-36,-37,-38,-39,-39,-39,-39,-38,-37,-36,-35,-33,-31,-29,-27,-25,-22,-20,-17,-15,-12,-10,-7,-5,-4,-2,-1,0,0,0,-1,-2,-3,-6,-8,-11,-15,-19,-24,-29,-34,-39,-45,-51,-57,-64,-70,-76,-82,-88,-93,-98,-103,-107,-110,-113,-115,-116,-117,-117,-116,-114,-111,-107,-103,-97,-91,-84,-77,-69,-60,-51,-41,-31,-21,-10,0,10,21,31,41,51,60,69,77,84,91,97,103,107,111,114,116,117,117,116,115,113,110,107,103,98,93,88,82,76,70,64,57,51,45,39,34,29,24,19,15,11,8,6,3,2,1,0,0,0,1,2,4,5,7,10,12,15,17,20,22,25,27,29,31,33,35,36,37,38,39,39,39,39,38,37,36,35,33,32,30,28,26,25,23,21,19,17,16,15,13,12,11,11,10,10,9,9,10,10,10,11,12,12,13,14,15,15,16,16,17,17,18,18,18,17,17,16,15,14,13,12,10,9,7,5,3,1
};

const PROGMEM char sqk_yamrect[] = 
{
-126,-120,-114,-108,-102,-95,-89,-83,-77,-71,-65,-58,-52,-47,-41,-35,-29,-23,-17,-12,-6,-1,4,9,14,19,24,29,34,39,44,48,53,57,61,66,70,74,77,81,85,88,91,94,97,100,103,106,108,110,113,115,117,118,120,121,123,124,125,126,126,127,127,127,127,127,127,127,126,126,125,124,123,121,120,118,117,115,113,110,108,106,103,100,97,94,91,88,85,81,77,74,70,66,61,57,53,48,44,39,34,29,24,19,14,9,4,-1,-6,-12,-17,-23,-29,-35,-41,-47,-52,-58,-65,-71,-77,-83,-89,-95,-102,-108,-114,-120,-127,-120,-114,-108,-102,-95,-89,-83,-77,-71,-65,-58,-52,-47,-41,-35,-29,-23,-17,-12,-6,-1,4,9,14,19,24,29,34,39,44,48,53,57,61,66,70,74,77,81,85,88,91,94,97,100,103,106,108,110,113,115,117,118,120,121,123,124,125,126,126,126,127,127,127,127,127,126,126,126,125,124,123,121,120,118,117,115,113,110,108,106,103,100,97,94,91,88,85,81,77,74,70,66,61,57,53,48,44,39,34,29,24,19,14,9,4,-1,-6,-12,-17,-23,-29,-35,-41,-47,-52,-58,-65,-71,-77,-83,-89,-95,-102,-108,-114,-120
};

const PROGMEM char sqk_yamsaw[] = 
{
0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,59,62,65,67,70,73,75,78,80,82,85,87,89,91,94,96,98,100,102,103,105,107,108,110,112,113,114,116,117,118,119,120,121,122,123,123,124,125,125,126,126,126,126,126,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,59,62,65,67,70,73,75,78,80,82,85,87,89,91,94,96,98,100,102,103,105,107,108,110,112,113,114,116,117,118,119,120,121,122,123,123,124,125,125,126,126,126,126,126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0
};

#define WAVEAM 8 //array size - 1

char* wavepointers[9] =
{
  sqk_sine,
  sqk_tri,
  sqk_sqr,
  sqk_pulse,  
  sqk_saw,
  sqk_noise,
  sqk_hammond,
  sqk_yamrect,  
  sqk_yamsaw
};

char oscAtable[256]   __attribute__ ((aligned(256))) = 
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

char oscBtable[256]   __attribute__ ((aligned(256))) = 
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

#endif
