#ifndef _sqk_osc
#define _sqk_osc

struct SQKOscillator                        //MAIN OSCILLATOR STRUCT
{
    volatile unsigned int   m_freq;         //Frequency
    volatile unsigned int   m_phase;        //Phase accumulator
    volatile char*          m_wave;         //Pointer to wavetable
    volatile char           m_amplitude;    //Amplitude

    char                    m_attack;       //Attack rate
    char                    m_decay;        //Decay rate
    char                    m_sustain;      //Sustain level
    char                    m_release;      //Release rate
    char                    m_depth;        //maximum amplitude (mod depth or volume)
    bool                    m_stage;        //envelope stage (false = A, true = DS)
    char                    m_envlevel;     //current envelope level
    
    bool                    m_gate;         //Gate signal for envelope
    unsigned int            m_note;         //Current note (used for polyphony management)
    float                   m_detune;       //tuning factor, times two, three etc
    int                     m_cents;        //cents tuning
    int                     m_oct;          //octave tuning
};

struct SQKOscillator oscillators[NUM_OSCS];

/*struct SQKLFO
{
    unsigned int m_phase;
    char* m_wave;
};

SQKLFO vibratolfo;*/

#endif
