#ifndef _sqk_controls
#define _sqk_controls

int knobvals[16];
char counter = 0;
bool firsttime = true;
bool FM = true;

int deadzone(int in)
{
    if(in < 480 || in > 544)
    {
        return in;
    }
    
    return 512;
}

char lerp(int v0, int v1, int t) 
{
  return char(((255 - t) * v0 + t * v1) >> 8);
}

void ScanControls()
{
    //check FM/Additive switch
    if(digitalRead2(32) == HIGH && !FM)
        FM = true;
    if(digitalRead2(32) == LOW && FM)
        FM = false;
    
    //knobs go from A0 to A15
    int temp;

    switch(counter)
    {
    case 0:
    {
        //A0 = OP1 release
        temp = analogRead(A0);
        if(knobvals[0] != temp || firsttime)
        {
            knobvals[0] = temp;
            oscillators[0].m_release = 64 - (temp >> 4);
            oscillators[2].m_release = oscillators[0].m_release;
            oscillators[4].m_release = oscillators[0].m_release;
            oscillators[6].m_release = oscillators[0].m_release;
        }
        break;
    }
    case 1:
    {
        //A1 = OP1 sustain
        temp = analogRead(A1);
        if(knobvals[1] != temp || firsttime)
        {
            knobvals[1] = temp;
            oscillators[0].m_sustain = (temp) >> 4;
            oscillators[2].m_sustain = oscillators[0].m_sustain;
            oscillators[4].m_sustain = oscillators[0].m_sustain;
            oscillators[6].m_sustain = oscillators[0].m_sustain;
        }
        break;
    }
    case 2:
    {
        //A2 = OP1 decay
        temp = analogRead(A2);
        if(knobvals[2] != temp || firsttime)
        {
            knobvals[2] = temp;
            oscillators[0].m_decay = 64 - (temp >> 4);
            oscillators[2].m_decay = oscillators[0].m_decay;
            oscillators[4].m_decay = oscillators[0].m_decay;
            oscillators[6].m_decay = oscillators[0].m_decay;
        }
        break;
    }
    case 3:
    {
        //A3 = OP1 attack
        temp = analogRead(A3);
        if(knobvals[3] != temp || firsttime)
        {
            knobvals[3] = temp;
            oscillators[0].m_attack = 64 - (temp >> 4);
            oscillators[2].m_attack = oscillators[0].m_attack;
            oscillators[4].m_attack = oscillators[0].m_attack;
            oscillators[6].m_attack = oscillators[0].m_attack;
        }
        break;
    }
    case 4:
    {
        //A4 = OP1 tune
        temp = deadzone(analogRead(A4));
        if(knobvals[4] != temp || firsttime)
        {
            knobvals[4] = temp;
            oscillators[0].m_cents = map(temp, 0, 1023, -1200, 1200);
            oscillators[0].m_detune = pow(2.0,((float)oscillators[0].m_cents/1200.0) + (float)oscillators[0].m_oct);
            oscillators[2].m_detune = oscillators[0].m_detune;
            oscillators[4].m_detune = oscillators[0].m_detune;
            oscillators[6].m_detune = oscillators[0].m_detune;

            oscillators[0].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[0].m_note]) * oscillators[0].m_detune;
            oscillators[2].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[2].m_note]) * oscillators[2].m_detune;
            oscillators[4].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[4].m_note]) * oscillators[4].m_detune;
            oscillators[6].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[6].m_note]) * oscillators[6].m_detune;
        }
        break;
    }
    case 5:
    {
        //A5 = OP1 octave
        temp = analogRead(A5);
        if(knobvals[5] != temp || firsttime)
        {
            knobvals[5] = temp;
            oscillators[0].m_oct = map(temp, 0, 1023, -256, 256)/128;
            oscillators[0].m_detune = pow(2.0,((float)oscillators[0].m_cents/1200.0) + (float)oscillators[0].m_oct);
            oscillators[2].m_detune = oscillators[0].m_detune;
            oscillators[4].m_detune = oscillators[0].m_detune;
            oscillators[6].m_detune = oscillators[0].m_detune;

            oscillators[0].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[0].m_note]) * oscillators[0].m_detune;
            oscillators[2].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[2].m_note]) * oscillators[2].m_detune;
            oscillators[4].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[4].m_note]) * oscillators[4].m_detune;
            oscillators[6].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[6].m_note]) * oscillators[6].m_detune;
        }
        break;
    }
    case 6:
    {
        //A6 = OP1 waveform
        temp = analogRead(A6);
        if(knobvals[6] != temp || firsttime)
        {
            knobvals[6] = temp;
            int index = map(temp, 0, 1023, 0, WAVEAM);
            //(signed char)pgm_read_byte
            //oscillators[0].m_wave = oscillators[2].m_wave = oscillators[4].m_wave = oscillators[6].m_wave = wavepointers[index];
            for(int i = 0; i < 256; i++)
            {
                oscAtable[i] = (signed char)pgm_read_byte(&wavepointers[index][i]);
            }
        }
        break;
        
    }
    case 7:
    {
        //A7 = OP2 waveform
        temp = analogRead(A7);
        if(knobvals[7] != temp || firsttime)
        {
            knobvals[7] = temp;
            int index = map(temp, 0, 1023, 0, WAVEAM);
            //oscillators[1].m_wave = oscillators[3].m_wave = oscillators[5].m_wave = oscillators[7].m_wave = wavepointers[index];
            for(int i = 0; i < 256; i++)
            {
                oscBtable[i] = (signed char)pgm_read_byte(&wavepointers[index][i]);
            }
        }
        break;        
    }
    case 8:
    {
        //A8 = OP2 octave
        temp = analogRead(A8);
        if(knobvals[8] != temp || firsttime)
        {
            knobvals[8] = temp;
            oscillators[1].m_oct = map(temp, 0, 1023, -256, 256)/128;
            oscillators[1].m_detune = pow(2.0,((float)oscillators[1].m_cents/1200.0) + (float)oscillators[1].m_oct);
            oscillators[3].m_detune = oscillators[1].m_detune;
            oscillators[5].m_detune = oscillators[1].m_detune;
            oscillators[7].m_detune = oscillators[1].m_detune;

            oscillators[1].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[1].m_note]) * oscillators[1].m_detune;
            oscillators[3].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[3].m_note]) * oscillators[3].m_detune;
            oscillators[5].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[5].m_note]) * oscillators[5].m_detune;
            oscillators[7].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[7].m_note]) * oscillators[7].m_detune;
        }
        break;
    }
    case 9:
    {
        //A9 = OP2 tune
        temp = deadzone(analogRead(A9));
        if(knobvals[9] != temp || firsttime)
        {
            knobvals[9] = temp;
            oscillators[1].m_cents = map(temp, 0, 1023, -1200, 1200);
            oscillators[1].m_detune = pow(2.0,((float)oscillators[1].m_cents/1200.0) + (float)oscillators[1].m_oct);
            oscillators[3].m_detune = oscillators[1].m_detune;
            oscillators[5].m_detune = oscillators[1].m_detune;
            oscillators[7].m_detune = oscillators[1].m_detune;

            oscillators[1].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[1].m_note]) * oscillators[1].m_detune;
            oscillators[3].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[3].m_note]) * oscillators[3].m_detune;
            oscillators[5].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[5].m_note]) * oscillators[5].m_detune;
            oscillators[7].m_freq = pgm_read_word(&SQK_PITCHS[oscillators[7].m_note]) * oscillators[7].m_detune;
        }
        break;
    }
    case 10:
    {
        //A10 = OP2 attack
        temp = analogRead(A10);
        if(knobvals[10] != temp || firsttime)
        {
            knobvals[10] = temp;
            oscillators[1].m_attack = 64 - (temp >> 4);
            oscillators[3].m_attack = oscillators[1].m_attack;
            oscillators[5].m_attack = oscillators[1].m_attack;
            oscillators[7].m_attack = oscillators[1].m_attack;
        }
        break;
    }
    case 11:
    {
        //A11 = OP2 decay
        temp = analogRead(A11);
        if(knobvals[11] != temp || firsttime)
        {
            knobvals[11] = temp;
            oscillators[1].m_decay = 64 - (temp >> 4);
            oscillators[3].m_decay = oscillators[1].m_decay;
            oscillators[5].m_decay = oscillators[1].m_decay;
            oscillators[7].m_decay = oscillators[1].m_decay;
        }
        break;
    }
    case 12:
    {
        //A12 = OP2 sustain
        temp = analogRead(A12);
        if(knobvals[12] != temp || firsttime)
        {
            knobvals[12] = temp;
            oscillators[1].m_sustain = (temp) >> 3;
            oscillators[3].m_sustain = oscillators[1].m_sustain;
            oscillators[5].m_sustain = oscillators[1].m_sustain;
            oscillators[7].m_sustain = oscillators[1].m_sustain;
        }
        break;
    }
    case 13:
    {
        //A13 = OP2 release
        temp = analogRead(A13);
        if(knobvals[13] != temp || firsttime)
        {
            knobvals[13] = temp;
            oscillators[1].m_release = 64 - (temp >> 4);
            oscillators[3].m_release = oscillators[1].m_release;
            oscillators[5].m_release = oscillators[1].m_release;
            oscillators[7].m_release = oscillators[1].m_release;
        }
        break;
    }
    case 14:
    {
        //A14 = OP2 volume
        temp = analogRead(A14);
        if(knobvals[14] != temp || firsttime)
        {
            knobvals[14] = temp;
            oscillators[1].m_depth = (temp) >> 4;
            oscillators[3].m_depth = oscillators[1].m_depth;
            oscillators[5].m_depth = oscillators[1].m_depth;
            oscillators[7].m_depth = oscillators[1].m_depth;
        }
        break;
    }
    case 15:
    {
        //A15 = OP1 mod/volume
        temp = analogRead(A15);
        if(knobvals[15] != temp || firsttime)
        {
            knobvals[15] = temp;
            oscillators[0].m_depth = (temp) >> 4;
            oscillators[2].m_depth = oscillators[0].m_depth;
            oscillators[4].m_depth = oscillators[0].m_depth;
            oscillators[6].m_depth = oscillators[0].m_depth;
        }
        break;
    }    
    default: break;
    }
    
    ++counter;
    if(counter > 15)
    {
        counter = 0;
        firsttime = false;
    }
}

#endif
