'===============================================================
'SIMPLE RAYTRACER WITH SPHERES
'By draggie/jeroen
'===============================================================
DEFINT A-Z

CONST pi = 3.141593
CONST inf = 9999!

'---------------------------------------------------------------
'types and their functions
'---------------------------------------------------------------

TYPE rgbcolor           'defines an RGB color
        R AS INTEGER
        g AS INTEGER
        b AS INTEGER
END TYPE


TYPE vector             'defines a vector or a point in 3D space
        x AS SINGLE
        y AS SINGLE
        z AS SINGLE
END TYPE

DECLARE SUB vectoradd (R AS vector, a AS vector, b AS vector)
DECLARE SUB vectorsub (R AS vector, a AS vector, b AS vector)
DECLARE SUB vectorlen (R AS SINGLE, a AS vector)
DECLARE SUB vectornorm (a AS vector)
DECLARE SUB vectordot (R AS SINGLE, a AS vector, b AS vector)

TYPE sphere             'defines a 3D sphere
        C AS vector     'position vector
        R AS SINGLE     'radius
        col AS rgbcolor 'color of the sphere
        refl AS INTEGER 'if the surface is reflective
END TYPE

TYPE light
        position AS vector
        intensity AS SINGLE
END TYPE

'---------------------------------------------------------------
'vars and subroutines for raytracing
'---------------------------------------------------------------

DIM SHARED scenespheres(4) AS sphere 'the spheres in our scene
DIM SHARED sphereamount AS INTEGER
DIM SHARED projplaneD AS SINGLE

DIM SHARED ViewH AS SINGLE
DIM SHARED ViewW AS SINGLE
DIM SHARED CanvasH AS SINGLE
DIM SHARED CanvasW AS SINGLE

DECLARE SUB closestIntersection (foundsphere AS INTEGER, closestsphere AS sphere, closestt AS SINGLE, O AS vector, D AS vector, tmin AS SINGLE, tmax AS SINGLE)
DECLARE SUB intersectRaySphere (rone AS SINGLE, rtwo AS SINGLE, O AS vector, D AS vector, sph AS sphere)
DECLARE SUB traceRay (R AS INTEGER, O AS vector, D AS vector, tmin AS SINGLE, tmax AS SINGLE, depth AS INTEGER)
DECLARE SUB reflectRay (rf AS vector, R AS vector, N AS vector)
DECLARE SUB canvasToViewport (R AS vector, x AS SINGLE, y AS SINGLE)
DECLARE SUB computeLighting (R AS SINGLE, P AS vector, N AS vector)


'---------------------------------------------------------------
'MAIN PROGRAM
'---------------------------------------------------------------

SCREEN 13

'this little tiddybit creates a greyscale color palette
FOR i = 0 TO 15
        OUT &H3C8, i
        OUT &H3C9, i * 4
        OUT &H3C9, i * 4
        OUT &H3C9, i * 4
NEXT i

sphereamount = 4

scenespheres(0).C.x = 0!
scenespheres(0).C.y = 0!
scenespheres(0).C.z = 5!
scenespheres(0).R = 1!
scenespheres(0).col.R = 14
scenespheres(0).col.g = 14
scenespheres(0).col.b = 14
scenespheres(0).refl = 1

scenespheres(1).C.x = 2!
scenespheres(1).C.y = -1!
scenespheres(1).C.z = 3.7
scenespheres(1).R = 1!
scenespheres(1).col.R = 14
scenespheres(1).col.g = 14
scenespheres(1).col.b = 14

scenespheres(2).C.x = -2!
scenespheres(2).C.y = 0!
scenespheres(2).C.z = 4!
scenespheres(2).R = 1!
scenespheres(2).col.R = 14
scenespheres(2).col.g = 14
scenespheres(2).col.b = 14

scenespheres(3).C.x = 0!
scenespheres(3).C.y = 501!
scenespheres(3).C.z = 5!
scenespheres(3).R = 500.5
scenespheres(3).col.R = 14
scenespheres(3).col.g = 14
scenespheres(3).col.b = 14
scenespheres(3).refl = 1        'this floorsphere is reflective


DIM SHARED scenelight AS light
scenelight.intensity = .8
scenelight.position.x = 2!
scenelight.position.y = -2!
scenelight.position.z = 2!

DIM SHARED ambientlight AS SINGLE
ambientlight = .2

ViewW = 1!            'viewport width
ViewH = 1!            'viewport height
projplaneD = 1!       'viewport depth (z) is also projection plane

CanvasW = 320!       'canvas/screen width
CanvasH = 200!       'canvas/screen height

DIM origin AS vector

origin.x = 0!
origin.y = 0!
origin.z = 0!

CLS

FOR i = 0 TO 3
        FOR Cx! = i TO CanvasW! STEP 4
              FOR Cy! = 0! TO CanvasH!
                        DIM Dvec AS vector
                        DIM clr AS INTEGER
                       
                        canvasToViewport Dvec, Cx! - 160!, Cy! - 100!
                        traceRay clr, origin, Dvec, 1!, inf, 1
                        IF clr = 0 THEN
                                PSET (Cx!, Cy!), 14 - (Cy! * .07)
                        ELSE
                                PSET (Cx!, Cy!), clr
                        END IF
              NEXT Cy!
        NEXT Cx!
NEXT i

'converts between screen and view space? yes yes derp derp hurr weh heh
SUB canvasToViewport (R AS vector, x AS SINGLE, y AS SINGLE)
        R.x! = x! * (ViewW! / CanvasW!)
        R.y! = y! * (ViewH! / CanvasH!)
        R.z! = projplaneD!
END SUB

'finds the closest ray-sphere intersection
SUB closestIntersection (foundsphere AS INTEGER, closestsphere AS sphere, closestt AS SINGLE, O AS vector, D AS vector, tmin AS SINGLE, tmax AS SINGLE)
       
        DIM tone AS SINGLE
        DIM ttwo AS SINGLE
       
        closestt = inf
        FOR i = 0 TO sphereamount - 1
              intersectRaySphere tone, ttwo, O, D, scenespheres(i)
              IF tone > tmin AND tone < tmax AND tone < closestt THEN
                    closestt = tone
                    closestsphere = scenespheres(i)
                    foundsphere = 1
              END IF
             
              IF ttwo > tmin AND ttwo < tmax AND ttwo < closestt THEN
                    closestt = ttwo
                    closestsphere = scenespheres(i)
                    foundsphere = 1
              END IF
        NEXT i

END SUB

'calculates scene light intensity for a pixel
'bear in mind that this only does a single light
'but can be easily expanded into a for loop to iterate all lights
SUB computeLighting (R AS SINGLE, P AS vector, N AS vector)
        DIM L AS vector
        DIM ndotl AS SINGLE
        DIM nlen AS SINGLE
        DIM llen AS SINGLE

        vectorsub L, scenelight.position, P

        'do a shadow zhing
        DIM shadowsphere AS sphere
        DIM shadowt AS SINGLE
        DIM foundshadow AS INTEGER
        closestIntersection foundshadow, shadowsphere, shadowt, P, L, .001, inf

        IF foundshadow = 0 THEN
                'diffuse lighting calculation
                vectordot ndotl, N, L
                vectorlen nlen, N
                vectorlen llen, L

                IF ndotl > 0! THEN
                      R = R + ((scenelight.intensity * ndotl) / (nlen * llen))
                END IF
        END IF
END SUB

'solves quadratic equation for ray-sphere intersection
SUB intersectRaySphere (rone AS SINGLE, rtwo AS SINGLE, O AS vector, D AS vector, sph AS sphere)
        DIM C AS vector
        DIM R AS SINGLE
        DIM oc AS vector
        DIM kone AS SINGLE
        DIM ktwo AS SINGLE
        DIM kthree AS SINGLE
        DIM discriminant AS SINGLE

        C = sph.C
        R = sph.R
        vectorsub oc, O, C

        vectordot kone, D, D
        vectordot ktwo, oc, D
        ktwo = ktwo * 2!
        vectordot kthree, oc, oc
        kthree = kthree - (R * R)

        discriminant = (ktwo * ktwo) - (4! * kone * kthree)
        IF discriminant < 0! THEN
              rone = inf
              rtwo = inf
        ELSE
              rone = (-ktwo + SQR(discriminant)) / (2! * kone)
              rtwo = (-ktwo - SQR(discriminant)) / (2! * kone)
        END IF
END SUB

'computes the reflected ray rf from ray R and normal N
SUB reflectRay (rf AS vector, R AS vector, N AS vector)
        DIM refcal AS vector
        DIM refdot AS SINGLE

        vectordot refdot, N, R

        refcal.x = 2! * N.x * refdot
        refcal.y = 2! * N.y * refdot
        refcal.z = 2! * N.z * refdot
       
        vectorsub rf, refcal, R
END SUB

'return color of sphere (or background) within range of t
SUB traceRay (R AS INTEGER, O AS vector, D AS vector, tmin AS SINGLE, tmax AS SINGLE, depth AS INTEGER)

        DIM clsph AS sphere
        DIM clt AS SINGLE
        DIM foundsph AS INTEGER
        foundsph = 0

        closestIntersection foundsph, clsph, clt, O, D, tmin, tmax
       
        IF foundsph = 1 THEN
              DIM P AS vector
              DIM N AS vector
              DIM nlen AS SINGLE
              DIM lres AS SINGLE
              DIM reflcol AS INTEGER
              lres = 0!

              P.x = O.x + (clt * D.x)
              P.y = O.y + (clt * D.y)
              P.z = O.z + (clt * D.z)

              vectorsub N, P, clsph.C
              vectorlen nlen, N
              N.x = N.x / nlen
              N.y = N.y / nlen
              N.z = N.z / nlen

              computeLighting lres, P, N

              'do a reflection if needed
              IF depth > 0 AND clsph.refl > 0 THEN
                    DIM RV AS vector
                    D.x = -D.x 'invert D
                    D.y = -D.y
                    D.z = -D.z
                    reflectRay RV, D, N
                    traceRay reflcol, P, RV, .001, inf, 0
              END IF

              R = 1 + (INT(clsph.col.R * lres) / 2) + (reflcol / 2)
        ELSE
              R = 0
        END IF

END SUB

'adds two vectors a+b together and returns this in r
SUB vectoradd (R AS vector, a AS vector, b AS vector)
        R.x = a.x + b.x
        R.y = a.y + b.y
        R.z = a.z + b.z
END SUB

'calculates the dot product r from vectors a and b
SUB vectordot (R AS SINGLE, a AS vector, b AS vector)
        R = (a.x * b.x) + (a.y * b.y) + (a.z * b.z)
END SUB

'returns the length of vector a as r
SUB vectorlen (R AS SINGLE, a AS vector)
        R = SQR((a.x * a.x) + (a.y * a.y) + (a.z * a.z))
END SUB

'normalizes a
SUB vectornorm (a AS vector)
        DIM veclen AS SINGLE
        vectorlen veclen, a
        a.x = a.x / veclen
        a.y = a.y / veclen
        a.z = a.z / veclen
END SUB

'subtracts two 3D vectors a-b and return as r
SUB vectorsub (R AS vector, a AS vector, b AS vector)
        R.x = a.x - b.x
        R.y = a.y - b.y
        R.z = a.z - b.z
END SUB

