
#ifndef _DCO_H
#define _DCO_H

//Dradique DCO struct

/*
PD description:
Casio's implementation of PD used oscillators generated by modulator and carrier waveforms, synchronised to each other per-cycle. 
The modulators were various angular waves that could 'distort' the carrier's sine into other shapes, 
to a degree derived from the "DCW" envelope.

A modulator phase line can also be distorted by adding a waveform (triangle etc) to it.
https://electricdruid.net/phase-distortion-synthesis/

An oddity:
If you layer 2 waveforms they are not played at the same time & mixed but one after the other
this creates a new kind of "waveform" with a sub-octave tone to it.
We could have two pieces of sequential memory reserved for two wavetables and running the counter over those
same for the modulator wavetables

*/

//doing CZ style resonance from Wikipedia: https://en.wikipedia.org/wiki/Phase_distortion_synthesis
/*
(a) The base frequency counter (window function), wrapping around every period.
(b) The resonance frequency counter at a (slightly) higher frequency, being reset (or "synced") when the base counter wraps around.
(c) The resonance frequency counter used as a sine wave readout. Note the nasty sudden jump at the reset!
(d) The inverted base frequency counter (window function).
(e) Multiplying c by d. The sudden jump in c is now leveled out.

The window function can be various waveshapes and these shapes are essentially the root waveform on which the
resonant sine wave is superimposed.


ABOUT FREQS:
(((stepsamount * frequency) / interruptfreq) * multiplier) / 2
steps amount is usually 65536 (16 bits unsigned)
when doing the classic overflow method with an uint
multiplier is optional for fixed point maths

*/

//global DCO params
struct DCO_param
{
  uint16_t value;
  uint16_t mini;
  uint16_t maxi;
  bool expo;
};

DCO_param dummy; //for no user param

DCO_param detuneA; //detune for Dual mode
DCO_param detuneB;

DCO_param env_attack;     //1-512
DCO_param env_decay;      //1-512
DCO_param env_sustain;    //0-1023
DCO_param env_release;    //1-512

DCO_param mod_attack;     //1-512
DCO_param mod_decay;      //1-512
DCO_param mod_sustain;    //0-1023
DCO_param mod_release;    //1-512

DCO_param mod_cutoff;     //0-31
DCO_param mod_resonance;  //0-31

DCO_param waveformA_id;
DCO_param waveformB_id;
  
DCO_param modulatorA_id;
DCO_param modulatorB_id;

//temp storage
uint16_t temp_env_attack = 0;
uint16_t temp_env_decay = 0;
uint16_t temp_env_sustain = 0;
uint16_t temp_env_release = 0;

uint16_t temp_mod_attack = 0;
uint16_t temp_mod_decay = 0;
uint16_t temp_mod_sustain = 0;
uint16_t temp_mod_release = 0;

uint16_t temp_mod_cutoff = 0;
uint16_t temp_mod_resonance = 0;

uint16_t temp_waveformA_id = 0;
uint16_t temp_waveformB_id = 0;

uint16_t temp_modulatorA_id = 0;
uint16_t temp_modulatorB_id = 0;


//DCO struct, technically 2 DCO's in 1
struct DCO
{
  //property values
  byte note;
  bool gate;
  bool env_stage;
  bool mod_stage;
  bool busy;

  int16_t envelope;
  int16_t modulation;
  int16_t resofreq;

  //processing values
  volatile int32_t result_prev;  //for envelope faff
  
  volatile uint16_t freq;         //phase increments
  volatile uint16_t counter;      //phase counter

  volatile uint16_t resocounter;  //CZ style resonance

  volatile int16_t waveform[1024];  //carrier waveforms * 2
  volatile int16_t modulator[1024]; //modulator waveforms * 2 (distorts phase)

  volatile int16_t mod_depth;      //modulation depth 0 - 63
  volatile int16_t env_val;        //envelope value 0 - 63
};

#endif
