
#ifndef _TABLES_H
#define _TABLES_H

//note frequencies

uint16_t NOTES[] = 
{
  //C1
  49,51,55,58,61,65,69,73,77,82,87,92,

  //C2
  97,103,109,116,122,130,137,146,154,163,173,183,

  //C3
  194,206,218,231,245,259,275,291,309,327,346,367,

  //C4
  389,412,436,462,490,519,550,582,617,654,693,734,

  //c5
  778

};

//wavetables and such
//waveforms are between -512 - 512, 512 values!
//modulators are between 0 - 255, 512 values!


//WAVEFORMS
int16_t tab_cos[512] = 
{
  -512,-512,-512,-512,-512,-512,-511,-511,-510,-509,-509,-508,-507,-506,-505,-504,-503,-501,-500,-499,-497,-496,-494,-492,-490,-489,-487,-485,-483,-480,-478,-476,-474,-471,-469,-466,-463,-461,-458,-455,-452,-449,-446,-443,-440,-436,-433,-430,-426,-423,-419,-415,-412,-408,-404,-400,-396,-392,-388,-384,-380,-376,-371,-367,-363,-358,-354,-349,-344,-340,-335,-330,-325,-320,-315,-311,-305,-300,-295,-290,-285,-280,-274,-269,-264,-258,-253,-247,-242,-236,-231,-225,-219,-214,-208,-202,-196,-191,-185,-179,-173,-167,-161,-155,-149,-143,-137,-131,-125,-119,-113,-107,-100,-94,-88,-82,-76,-69,-63,-57,-51,-44,-38,-32,-26,-19,-13,-7,-1,6,12,18,25,31,37,43,50,56,62,68,75,81,87,93,99,106,112,118,124,130,136,142,148,154,160,166,172,178,184,190,195,201,207,213,218,224,230,235,241,246,252,257,263,268,273,279,284,289,294,299,304,310,314,319,324,329,334,339,343,348,353,357,362,366,370,375,379,383,387,391,395,399,403,407,411,414,418,422,425,429,432,435,439,442,445,448,451,454,457,460,462,465,468,470,473,475,477,479,482,484,486,488,489,491,493,495,496,498,499,500,502,503,504,505,506,507,508,508,509,510,510,511,511,511,511,511,512,511,511,511,511,511,510,510,509,508,508,507,506,505,504,503,502,500,499,498,496,495,493,491,489,488,486,484,482,479,477,475,473,470,468,465,462,460,457,454,451,448,445,442,439,435,432,429,425,422,418,414,411,407,403,399,395,391,387,383,379,375,370,366,362,357,353,348,343,339,334,329,324,319,314,310,304,299,294,289,284,279,273,268,263,257,252,246,241,235,230,224,218,213,207,201,195,190,184,178,172,166,160,154,148,142,136,130,124,118,112,106,99,93,87,81,75,68,62,56,50,43,37,31,25,18,12,6,-1,-7,-13,-19,-26,-32,-38,-44,-51,-57,-63,-69,-76,-82,-88,-94,-100,-107,-113,-119,-125,-131,-137,-143,-149,-155,-161,-167,-173,-179,-185,-191,-196,-202,-208,-214,-219,-225,-231,-236,-242,-247,-253,-258,-264,-269,-274,-280,-285,-290,-295,-300,-305,-311,-315,-320,-325,-330,-335,-340,-344,-349,-354,-358,-363,-367,-371,-376,-380,-384,-388,-392,-396,-400,-404,-408,-412,-415,-419,-423,-426,-430,-433,-436,-440,-443,-446,-449,-452,-455,-458,-461,-463,-466,-469,-471,-474,-476,-478,-480,-483,-485,-487,-489,-490,-492,-494,-496,-497,-499,-500,-501,-503,-504,-505,-506,-507,-508,-509,-509,-510,-511,-511,-512,-512,-512,-512,-512
};

int16_t tab_sine[512] = 
{
  0,-7,-13,-19,-26,-32,-38,-44,-51,-57,-63,-69,-76,-82,-88,-94,-100,-107,-113,-119,-125,-131,-137,-143,-149,-155,-161,-167,-173,-179,-185,-191,-196,-202,-208,-214,-219,-225,-231,-236,-242,-247,-253,-258,-264,-269,-274,-280,-285,-290,-295,-300,-305,-311,-315,-320,-325,-330,-335,-340,-344,-349,-354,-358,-363,-367,-371,-376,-380,-384,-388,-392,-396,-400,-404,-408,-412,-415,-419,-423,-426,-430,-433,-436,-440,-443,-446,-449,-452,-455,-458,-461,-463,-466,-469,-471,-474,-476,-478,-480,-483,-485,-487,-489,-490,-492,-494,-496,-497,-499,-500,-501,-503,-504,-505,-506,-507,-508,-509,-509,-510,-511,-511,-512,-512,-512,-512,-512,-512,-512,-512,-512,-512,-512,-511,-511,-510,-509,-509,-508,-507,-506,-505,-504,-503,-501,-500,-499,-497,-496,-494,-492,-490,-489,-487,-485,-483,-480,-478,-476,-474,-471,-469,-466,-463,-461,-458,-455,-452,-449,-446,-443,-440,-436,-433,-430,-426,-423,-419,-415,-412,-408,-404,-400,-396,-392,-388,-384,-380,-376,-371,-367,-363,-358,-354,-349,-344,-340,-335,-330,-325,-320,-315,-311,-305,-300,-295,-290,-285,-280,-274,-269,-264,-258,-253,-247,-242,-236,-231,-225,-219,-214,-208,-202,-196,-191,-185,-179,-173,-167,-161,-155,-149,-143,-137,-131,-125,-119,-113,-107,-100,-94,-88,-82,-76,-69,-63,-57,-51,-44,-38,-32,-26,-19,-13,-7,0,6,12,18,25,31,37,43,50,56,62,68,75,81,87,93,99,106,112,118,124,130,136,142,148,154,160,166,172,178,184,190,195,201,207,213,218,224,230,235,241,246,252,257,263,268,273,279,284,289,294,299,304,310,314,319,324,329,334,339,343,348,353,357,362,366,370,375,379,383,387,391,395,399,403,407,411,414,418,422,425,429,432,435,439,442,445,448,451,454,457,460,462,465,468,470,473,475,477,479,482,484,486,488,489,491,493,495,496,498,499,500,502,503,504,505,506,507,508,508,509,510,510,511,511,511,511,511,512,511,511,511,511,511,510,510,509,508,508,507,506,505,504,503,502,500,499,498,496,495,493,491,489,488,486,484,482,479,477,475,473,470,468,465,462,460,457,454,451,448,445,442,439,435,432,429,425,422,418,414,411,407,403,399,395,391,387,383,379,375,370,366,362,357,353,348,343,339,334,329,324,319,314,310,304,299,294,289,284,279,273,268,263,257,252,246,241,235,230,224,218,213,207,201,195,190,184,178,172,166,160,154,148,142,136,130,124,118,112,106,99,93,87,81,75,68,62,56,50,43,37,31,25,18,12,6
};

int16_t tab_triangle[512] = 
{
  -512,-508,-504,-500,-496,-492,-488,-484,-480,-476,-472,-468,-464,-460,-456,-452,-448,-444,-440,-436,-432,-428,-424,-420,-416,-412,-408,-404,-400,-396,-392,-388,-384,-380,-376,-372,-368,-364,-360,-356,-352,-348,-344,-340,-336,-332,-328,-324,-320,-316,-312,-308,-304,-300,-296,-292,-288,-284,-280,-276,-272,-268,-264,-260,-256,-252,-248,-244,-240,-236,-232,-228,-224,-220,-216,-212,-208,-204,-200,-196,-192,-188,-184,-180,-176,-172,-168,-164,-160,-156,-152,-148,-144,-140,-136,-132,-128,-124,-120,-116,-112,-108,-104,-100,-97,-93,-89,-85,-80,-76,-72,-68,-64,-60,-56,-52,-48,-44,-40,-36,-32,-28,-24,-20,-16,-12,-8,-4,0,4,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,100,104,108,112,116,120,124,128,132,136,140,144,148,152,156,160,164,168,172,176,180,184,188,192,196,200,204,208,212,216,220,224,228,232,236,240,244,248,252,256,260,264,268,272,276,280,284,288,292,296,300,304,308,312,316,320,324,328,332,336,340,344,348,352,356,360,364,368,372,376,380,384,388,392,396,400,404,408,412,416,420,424,428,432,436,440,444,448,452,456,460,464,468,472,476,480,484,488,492,496,500,504,508,512,508,504,500,496,492,488,484,480,476,472,468,464,460,456,452,448,444,440,436,432,428,424,420,416,412,408,404,400,396,392,388,384,380,376,372,368,364,360,356,352,348,344,340,336,332,328,324,320,316,312,308,304,300,296,292,288,284,280,276,272,268,264,260,256,252,248,244,240,236,232,228,224,220,216,212,208,204,200,196,192,188,184,180,176,172,168,164,160,156,152,148,144,140,136,132,128,124,120,116,112,108,104,100,96,92,88,84,80,76,72,68,64,60,56,52,48,44,40,36,32,28,24,20,16,12,8,4,0,-4,-8,-12,-16,-20,-24,-28,-32,-36,-40,-44,-48,-52,-56,-60,-64,-68,-72,-76,-80,-85,-89,-93,-97,-100,-104,-108,-112,-116,-120,-124,-128,-132,-136,-140,-144,-148,-152,-156,-160,-164,-168,-172,-176,-180,-184,-188,-192,-196,-200,-204,-208,-212,-216,-220,-224,-228,-232,-236,-240,-244,-248,-252,-256,-260,-264,-268,-272,-276,-280,-284,-288,-292,-296,-300,-304,-308,-312,-316,-320,-324,-328,-332,-336,-340,-344,-348,-352,-356,-360,-364,-368,-372,-376,-380,-384,-388,-392,-396,-400,-404,-408,-412,-416,-420,-424,-428,-432,-436,-440,-444,-448,-452,-456,-460,-464,-468,-472,-476,-480,-484,-488,-492,-496,-500,-504,-508
};

int16_t tab_square[512] = 
{
  109,356,494,507,500,497,494,492,489,486,484,481,478,476,473,471,468,465,463,460,458,455,453,451,448,445,443,440,438,436,433,431,428,426,423,421,419,416,414,412,410,407,404,402,400,398,396,393,391,389,387,385,382,380,378,376,374,372,370,367,365,363,361,359,356,354,352,350,348,347,344,342,340,338,336,334,332,330,328,326,325,323,321,318,316,315,313,311,309,307,305,304,302,300,298,296,294,293,291,289,287,285,284,282,280,279,276,275,273,271,270,268,266,265,263,262,260,258,257,255,253,252,250,248,247,245,244,242,241,239,238,236,235,233,231,230,228,227,225,224,222,221,219,218,217,215,214,212,210,209,208,206,205,203,202,201,199,198,197,195,194,193,191,190,188,187,186,185,183,182,181,179,178,177,176,174,173,172,171,169,168,167,166,164,163,162,161,160,158,157,156,155,154,153,152,151,149,148,147,146,144,143,142,141,140,139,137,112,-20,-259,-421,-428,-422,-420,-418,-416,-414,-412,-410,-408,-405,-403,-401,-399,-397,-395,-393,-391,-389,-387,-385,-383,-381,-378,-377,-375,-373,-371,-369,-367,-365,-363,-361,-359,-357,-355,-353,-351,-350,-348,-346,-344,-342,-340,-338,-336,-334,-333,-331,-329,-328,-326,-324,-322,-320,-318,-317,-315,-313,-311,-310,-308,-307,-305,-303,-301,-300,-298,-296,-294,-293,-291,-290,-288,-287,-285,-283,-282,-280,-279,-277,-275,-274,-272,-271,-269,-268,-266,-265,-263,-262,-260,-259,-257,-255,-254,-253,-251,-250,-248,-247,-245,-244,-243,-241,-240,-239,-237,-236,-234,-233,-231,-230,-229,-227,-226,-225,-223,-222,-221,-219,-218,-217,-216,-214,-213,-211,-210,-209,-208,-206,-205,-204,-203,-201,-200,-199,-198,-197,-195,-194,-193,-191,-190,-189,-188,-187,-186,-185,-183,-182,-181,-180,-179,-178,-177,-176,-175,-173,-172,-171,-170,-169,-168,-167,-166,-164,-163,-162,-161,-160,-159,-158,-157,-156,-155,-154,-153,-152,-151,-150,-149,-148,-147,-146,-145,-144,-143,-142,-141,-140,-139,-138,-137,-136,-136,-135,-134,-133,-132,-131,-130,-129,-128,-127,-126,-125,-124,-124,-123,-122,-121,-120,-119,-118,-118,-117,-116,-115,-114,-113,-113,-112,-111,-110,-110,-109,-108,-107,-106,-105,-104,-103,-103,-102,-101,-100,-100,-99,-98,-97,-97,-96,-95,-94,-94,-93,-92,-92,-91,-90,-89,-89,-88,-87,-87,-86,-85,-84,-84,-83,-82,-81,-81,-80,-80,-79,-78,-78,-77,-76,-76,-75,-74,-74,-73,-73,-72,-71,-71,-70,-69,-69,-68,-68,-67,-66,-66,-65,-64,-64,-63,-62,-62,-61,-61,-60,-60,-59,-58,-58,-38
};

int16_t tab_saw[512] = 
{
  4,8,11,14,17,19,22,24,27,29,31,33,35,36,38,39,41,43,44,46,48,50,51,53,55,57,59,61,63,65,67,69,71,73,75,78,80,82,84,87,89,92,94,96,99,101,103,106,109,111,114,116,118,121,123,126,129,131,134,136,139,141,144,146,149,152,154,157,159,162,165,167,170,173,175,178,180,183,185,188,190,193,196,199,201,204,206,209,211,214,217,219,222,225,227,230,232,235,238,240,243,245,248,250,253,256,258,261,263,265,268,271,273,275,278,281,283,286,288,290,293,295,298,300,303,305,307,310,312,314,317,319,322,324,326,328,331,333,335,337,340,342,344,346,348,351,353,355,357,359,361,364,366,368,370,372,374,376,378,380,382,384,386,388,390,392,394,395,397,399,401,403,404,407,408,410,412,413,415,417,418,420,422,423,425,427,428,430,431,433,434,436,437,439,440,441,443,444,445,447,448,450,451,452,453,455,456,457,458,459,460,461,462,463,464,466,467,467,468,470,471,472,472,473,474,475,476,477,477,478,479,479,480,481,481,482,482,483,483,484,484,485,485,486,486,487,487,487,488,488,488,489,489,489,489,489,490,490,488,475,425,337,230,157,92,29,-36,-84,-127,-160,-192,-221,-249,-278,-302,-324,-343,-361,-378,-394,-408,-419,-430,-439,-447,-456,-462,-468,-474,-478,-483,-487,-490,-494,-496,-499,-501,-503,-505,-506,-507,-508,-510,-510,-511,-512,-512,-512,-512,-512,-512,-512,-512,-512,-511,-511,-511,-510,-509,-509,-508,-507,-506,-505,-504,-503,-502,-501,-499,-498,-497,-495,-494,-493,-491,-489,-488,-486,-485,-483,-481,-480,-478,-476,-474,-472,-471,-468,-466,-464,-462,-460,-458,-456,-454,-452,-450,-447,-445,-443,-441,-438,-436,-434,-432,-430,-426,-424,-422,-419,-417,-415,-412,-410,-407,-404,-402,-399,-397,-394,-392,-389,-387,-384,-381,-378,-376,-373,-370,-368,-365,-362,-359,-356,-354,-351,-348,-345,-342,-339,-337,-333,-331,-328,-325,-322,-319,-316,-313,-310,-308,-305,-302,-298,-295,-293,-290,-287,-284,-281,-277,-275,-272,-269,-266,-263,-260,-256,-254,-251,-247,-245,-242,-239,-236,-232,-229,-226,-223,-220,-217,-215,-211,-208,-205,-202,-199,-196,-192,-189,-186,-184,-181,-177,-174,-172,-168,-165,-162,-159,-156,-153,-150,-147,-144,-141,-138,-135,-132,-129,-126,-123,-120,-117,-114,-111,-109,-105,-102,-99,-96,-94,-90,-88,-84,-82,-79,-76,-73,-70,-67,-64,-62,-59,-56,-53,-50,-48,-45,-42,-39,-36,-33,-31,-28,-25,-22,-19,-16,-13,-10,-6
};

//MODULATORS
int16_t mod_tab_sine[512] =
{
  127,125,123,122,120,119,117,116,114,113,111,109,108,106,105,103,102,100,99,97,96,94,93,91,90,88,87,85,84,82,81,79,78,76,75,74,72,71,69,68,67,65,64,63,61,60,59,57,56,55,53,52,51,50,48,47,46,45,44,42,41,40,39,38,37,36,35,33,32,31,30,29,28,27,26,25,24,24,23,22,21,20,19,18,18,17,16,15,14,14,13,12,12,11,10,10,9,9,8,7,7,6,6,5,5,5,4,4,3,3,3,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,6,7,7,8,9,9,10,10,11,12,12,13,14,14,15,16,17,18,18,19,20,21,22,23,24,24,25,26,27,28,29,30,31,32,33,35,36,37,38,39,40,41,42,44,45,46,47,48,50,51,52,53,55,56,57,59,60,61,63,64,65,67,68,69,71,72,74,75,76,78,79,81,82,84,85,87,88,90,91,93,94,96,97,99,100,102,103,105,106,108,109,111,113,114,116,117,119,120,122,123,125,127,128,130,131,133,134,136,137,139,140,142,144,145,147,148,150,151,153,154,156,157,159,160,162,163,165,166,168,169,171,172,174,175,177,178,179,181,182,184,185,186,188,189,190,192,193,194,196,197,198,200,201,202,203,205,206,207,208,209,211,212,213,214,215,216,217,218,220,221,222,223,224,225,226,227,228,229,229,230,231,232,233,234,235,235,236,237,238,239,239,240,241,241,242,243,243,244,244,245,246,246,247,247,248,248,248,249,249,250,250,250,251,251,251,252,252,252,252,253,253,253,253,253,253,253,253,253,253,254,253,253,253,253,253,253,253,253,253,253,252,252,252,252,251,251,251,250,250,250,249,249,248,248,248,247,247,246,246,245,244,244,243,243,242,241,241,240,239,239,238,237,236,235,235,234,233,232,231,230,229,229,228,227,226,225,224,223,222,221,220,218,217,216,215,214,213,212,211,209,208,207,206,205,203,202,201,200,198,197,196,194,193,192,190,189,188,186,185,184,182,181,179,178,177,175,174,172,171,169,168,166,165,163,162,160,159,157,156,154,153,151,150,148,147,145,144,142,140,139,137,136,134,133,131,130,128
};

int16_t mod_tab_triangle[512] =
{
  0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,254,253,252,251,250,249,248,247,246,245,244,243,242,241,240,239,238,237,236,235,234,233,232,231,230,229,228,227,226,225,224,223,222,221,220,219,218,217,216,215,214,213,212,211,210,209,208,207,206,205,204,203,202,201,200,199,198,197,196,195,194,193,192,191,190,189,188,187,186,185,184,183,182,181,180,179,178,177,176,175,174,173,172,171,170,169,168,167,166,165,164,163,162,161,160,159,158,157,156,155,154,153,152,151,150,149,148,147,146,145,144,143,142,141,140,139,138,137,136,135,134,133,132,131,130,129,128,127,126,125,124,123,122,121,120,119,118,117,116,115,114,113,112,111,110,109,108,107,106,105,104,103,102,101,100,99,98,97,96,95,94,93,92,91,90,89,88,87,86,85,84,83,82,81,80,79,78,77,76,75,74,73,72,71,70,69,68,67,66,65,64,63,62,61,60,59,58,57,56,55,54,53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0
};

int16_t mod_tab_sawtriangle[512] = 
{
  0,1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,255,254,253,253,252,251,251,250,249,249,248,247,247,246,245,245,244,243,243,242,241,241,240,239,239,238,237,237,236,235,235,234,233,233,232,231,231,230,229,229,228,227,227,226,225,225,224,223,223,222,221,221,220,219,219,218,217,217,216,215,215,214,213,213,212,212,211,210,210,209,208,208,207,206,206,205,204,204,203,202,202,201,200,200,199,198,198,197,196,196,195,194,194,193,192,192,191,190,190,189,188,188,187,186,186,185,184,184,183,182,182,181,180,180,179,178,178,177,176,176,175,174,174,173,172,172,171,170,170,169,169,168,167,167,166,165,165,164,163,163,162,161,161,160,159,159,158,157,157,156,155,155,154,153,153,152,151,151,150,149,149,148,147,147,146,145,145,144,143,143,142,141,141,140,139,139,138,137,137,136,135,135,134,133,133,132,131,131,130,129,129,128,128,127,126,126,125,124,124,123,122,122,121,120,120,119,118,118,117,116,116,115,114,114,113,112,112,111,110,110,109,108,108,107,106,106,105,104,104,103,102,102,101,100,100,99,98,98,97,96,96,95,94,94,93,92,92,91,90,90,89,88,88,87,86,86,85,85,84,83,83,82,81,81,80,79,79,78,77,77,76,75,75,74,73,73,72,71,71,70,69,69,68,67,67,66,65,65,64,63,63,62,61,61,60,59,59,58,57,57,56,55,55,54,53,53,52,51,51,50,49,49,48,47,47,46,45,45,44,43,43,42,42,41,40,40,39,38,38,37,36,36,35,34,34,33,32,32,31,30,30,29,28,28,27,26,26,25,24,24,23,22,22,21,20,20,19,18,18,17,16,16,15,14,14,13,12,12,11,10,10,9,8,8,7,6,6,5,4,4,3,2,2,1
};

int16_t mod_tab_doubletriangle[512] = 
{
  0,1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,253,251,249,247,245,243,241,239,237,235,233,231,229,227,225,223,221,219,217,215,213,211,209,207,205,203,201,199,197,195,193,191,189,187,185,183,181,179,177,175,173,171,169,167,165,163,161,159,157,155,153,151,149,147,145,143,141,139,137,135,133,131,129,127,125,123,121,119,117,115,113,111,109,107,105,103,101,99,97,95,93,91,89,87,85,83,81,79,77,75,73,71,69,67,65,63,61,59,57,55,53,51,49,47,45,43,41,39,37,35,33,31,29,27,25,23,21,19,17,15,13,11,9,7,5,3,1,0,1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,253,251,249,247,245,243,241,239,237,235,233,231,229,227,225,223,221,219,217,215,213,211,209,207,205,203,201,199,197,195,193,191,189,187,185,183,181,179,177,175,173,171,169,167,165,163,161,159,157,155,153,151,149,147,145,143,141,139,137,135,133,131,129,127,125,123,121,119,117,115,113,111,109,107,105,103,101,99,97,95,93,91,89,87,85,83,81,79,77,75,73,71,69,67,65,63,61,59,57,55,53,51,49,47,45,43,41,39,37,35,33,31,29,27,25,23,21,19,17,15,13,11,9,7,5,3,1
};

int16_t mod_tab_square[512] = 
{
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

int16_t mod_tab_saw[512] = 
{
  127,128,129,129,130,131,132,133,134,135,135,136,137,138,139,140,141,141,142,143,144,145,145,146,147,148,149,149,150,151,152,152,153,154,155,156,156,157,158,159,159,160,161,161,162,163,163,164,165,166,166,167,168,168,169,170,171,171,172,173,173,174,175,175,176,177,177,178,178,179,180,180,181,182,182,183,183,184,185,185,186,186,187,188,188,189,189,190,191,191,192,192,193,193,194,194,195,196,196,197,197,198,198,199,199,200,200,201,202,202,203,203,204,204,205,205,206,206,207,207,208,208,209,209,210,210,210,211,211,212,212,213,213,214,214,215,215,216,216,216,217,217,218,218,219,219,220,220,220,221,221,222,222,223,223,223,224,224,225,225,225,226,226,227,227,227,228,228,229,229,229,230,230,230,231,231,232,232,232,233,233,233,234,234,234,235,235,236,236,236,237,237,237,238,238,238,239,239,239,240,240,240,241,241,241,242,242,242,242,243,243,243,244,244,244,245,245,245,246,246,246,246,247,247,247,248,248,248,248,249,249,249,250,250,250,250,251,251,251,252,252,252,252,253,253,253,253,254,254,254,254,253,242,211,163,114,70,44,26,15,9,5,2,1,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15,16,16,16,17,17,17,18,18,18,19,19,19,20,20,21,21,21,22,22,22,23,23,24,24,24,25,25,26,26,26,27,27,27,28,28,29,29,29,30,30,31,31,32,32,32,33,33,34,34,35,35,35,36,36,37,37,38,38,39,39,40,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,56,56,57,57,58,58,59,59,60,61,61,62,62,63,63,64,65,65,66,66,67,68,68,69,69,70,71,71,72,72,73,74,74,75,76,76,77,78,78,79,80,80,81,82,82,83,84,84,85,86,86,87,88,88,89,90,91,91,92,93,94,94,95,96,96,97,98,99,99,100,101,102,103,103,104,105,106,107,107,108,109,110,111,111,112,113,114,115,115,117,117,118,119,120,121,122,123,123,124,125,126
};

//waveforms pointer table
#define TAB_WAVEFORMS_NR 5
int16_t* TAB_WAVEFORMS[] =
{
  tab_cos,
  tab_sine,
  tab_triangle,
  tab_square,
  tab_saw
};

#define TAB_MODULATORS_NR 6
int16_t* TAB_MODULATORS[] =
{
  mod_tab_sine,
  mod_tab_triangle,
  mod_tab_doubletriangle,
  mod_tab_sawtriangle,
  mod_tab_saw,
  mod_tab_square
};

//USER KNOB EXPONENTIAL CONVERTER
uint16_t USR_EXPCONV[1024] =
{
  1023,1021,1019,1017,1015,1013,1011,1009,1007,1005,1003,1001,999,997,995,993,991,989,987,985,983,981,979,977,975,973,971,969,967,965,963,961,960,958,956,954,952,950,948,946,944,942,940,938,936,935,933,931,929,927,925,923,921,919,917,916,914,912,910,908,906,904,902,900,899,897,895,893,891,889,887,886,884,882,880,878,876,874,873,871,869,867,865,863,862,860,858,856,854,852,851,849,847,845,843,841,840,838,836,834,832,831,829,827,825,823,822,820,818,816,815,813,811,809,807,806,804,802,800,799,797,795,793,792,790,788,786,784,783,781,779,777,776,774,772,771,769,767,765,764,762,760,758,757,755,753,752,750,748,746,745,743,741,740,738,736,735,733,731,729,728,726,724,723,721,719,718,716,714,713,711,709,708,706,704,703,701,699,698,696,694,693,691,690,688,686,685,683,681,680,678,676,675,673,672,670,668,667,665,664,662,660,659,657,655,654,652,651,649,648,646,644,643,641,640,638,636,635,633,632,630,629,627,625,624,622,621,619,618,616,615,613,611,610,608,607,605,604,602,601,599,598,596,595,593,592,590,589,587,585,584,582,581,579,578,576,575,573,572,570,569,567,566,564,563,562,560,559,557,556,554,553,551,550,548,547,545,544,542,541,540,538,537,535,534,532,531,529,528,527,525,524,522,521,519,518,517,515,514,512,511,509,508,507,505,504,502,501,500,498,497,495,494,493,491,490,489,487,486,484,483,482,480,479,478,476,475,473,472,471,469,468,467,465,464,463,461,460,459,457,456,455,453,452,451,449,448,447,445,444,443,441,440,439,437,436,435,434,432,431,430,428,427,426,424,423,422,421,419,418,417,416,414,413,412,410,409,408,407,405,404,403,402,400,399,398,397,395,394,393,392,390,389,388,387,385,384,383,382,381,379,378,377,376,375,373,372,371,370,368,367,366,365,364,363,361,360,359,358,357,355,354,353,352,351,350,348,347,346,345,344,343,341,340,339,338,337,336,335,333,332,331,330,329,328,327,325,324,323,322,321,320,319,318,316,315,314,313,312,311,310,309,308,307,305,304,303,302,301,300,299,298,297,296,295,294,292,291,290,289,288,287,286,285,284,283,282,281,280,279,278,277,276,275,274,273,271,270,269,268,267,266,265,264,263,262,261,260,259,258,257,256,255,254,253,252,251,250,249,248,247,246,245,244,243,242,241,240,240,239,238,237,236,235,234,233,232,231,230,229,228,227,226,225,224,223,222,221,221,220,219,218,217,216,215,214,213,212,211,210,210,209,208,207,206,205,204,203,202,201,201,200,199,198,197,196,195,194,194,193,192,191,190,189,188,188,187,186,185,184,183,182,182,181,180,179,178,177,177,176,175,174,173,172,172,171,170,169,168,168,167,166,165,164,163,163,162,161,160,160,159,158,157,156,156,155,154,153,152,152,151,150,149,149,148,147,146,146,145,144,143,143,142,141,140,140,139,138,137,137,136,135,135,134,133,132,132,131,130,129,129,128,127,127,126,125,125,124,123,122,122,121,120,120,119,118,118,117,116,116,115,114,114,113,112,112,111,110,110,109,108,108,107,106,106,105,104,104,103,103,102,101,101,100,99,99,98,98,97,96,96,95,94,94,93,93,92,91,91,90,90,89,88,88,87,87,86,86,85,84,84,83,83,82,82,81,80,80,79,79,78,78,77,77,76,75,75,74,74,73,73,72,72,71,71,70,70,69,69,68,67,67,66,66,65,65,64,64,63,63,62,62,61,61,60,60,60,59,59,58,58,57,57,56,56,55,55,54,54,53,53,52,52,52,51,51,50,50,49,49,48,48,48,47,47,46,46,45,45,45,44,44,43,43,43,42,42,41,41,40,40,40,39,39,39,38,38,37,37,37,36,36,35,35,35,34,34,34,33,33,33,32,32,31,31,31,30,30,30,29,29,29,28,28,28,27,27,27,26,26,26,25,25,25,24,24,24,24,23,23,23,22,22,22,21,21,21,21,20,20,20,19,19,19,19,18,18,18,18,17,17,17,16,16,16,16,15,15,15,15,15,14,14,14,14,13,13,13,13,12,12,12,12,12,11,11,11,11,10,10,10,10,10,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

#endif
