
#ifndef _PITCHES_H
#define _PITCHES_H

//bass synth
#define BASS_CLOCK 8    //PORTB 0
#define VAC_PWM 9
#define VAC_CUTOFF 10
#define PWM_OUT 11      //PORTB 3
#define SAW_OUT 12      //PORTB 4
#define MIDI_ACTIVE 13

//controls
#define ATTACK A5
#define DECAY A4
#define WAVE A3

unsigned int pitchcounter = 0;
uint16_t bassnote = 0;

//LFO
int LFO = 0;
int LFOspd = 1;
bool LFOdir = true;

//AD envelope
bool gate = false;
int ENV = 0;
int envatt = 8;
int envdec = 1;

uint16_t SYNTH_PITCHES[] = 
{
  //C1  C#1 D1  D#1 E1  F1  F#1 G1  G#1 A1  A#1 B1
  959,  905,855,807,761,719,678,640,604,570,538,508,
  
  //C2  C#2 D2  D#2 E2  F2  F#2 G2  G#2 A2  A#2 B2
  480,  453,427,403,381,359,339,320,302,285,269,254,

  //C3  C#3 D3  D#3 E3  F3  F#3 G3  G#3 A3  A#3 B3
  240,  226,214,202,190,180,170,160,151,143,135,127,
  
  //C4  C#4 D4  D#4 E4  F4  F#4 G4  G#4 A4  A#4 B4
  120,  113,107,101,95, 90, 85, 80, 76, 71, 67, 64,

  //C5  C#5 D5  D#5 E5  F5  F#5 G5  G#5 A5  A#5 B5
  60,   57, 53, 50, 48, 45, 42, 40, 38, 36, 34, 32,

  //C6  C#6 D6  D#6 E6  F6  F#6 G6  G#6 A6  A#6 B6
  30,   28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 16
};

const PROGMEM uint16_t BASSLINE_ROCK[16] =
{
  480, 240, 0, 0, 480, 240, 0, 0,
  480, 240, 0, 0, 480, 240, 160, 143
};

const PROGMEM uint16_t BASSLINE_POP[16] =
{
  381, 381, 381, 381, 381, 381, 339, 320,
  285, 285, 285, 285, 285, 320, 320, 339
};

const PROGMEM uint16_t BASSLINE_SWING[16] =
{
  761, 640, 0, 761, 480, 0, 480, 427,
  427, 427, 0, 427, 427, 0, 427, 640
};

const PROGMEM uint16_t BASSLINE_SLOWROCK[16] =
{
  285, 320, 381, 508, 0, 0, 0, 381,
  508, 453, 427, 508, 0, 0, 0, 0
};

const PROGMEM uint16_t BASSLINE_MARCH[16] =
{
  381, 0, 190, 0, 381, 0, 190, 0,
  381, 339, 190, 320, 381, 0, 190, 320
};

const PROGMEM uint16_t BASSLINE_RAP[16] =
{
  761, 761, 0, 761, 640, 0, 761, 761,
  678, 640, 0, 640, 0, 640, 640, 0
};

const PROGMEM uint16_t BASSLINE_METAL[16] =
{
  480, 480, 480, 0, 480, 480, 480, 0,
  508, 381, 381, 381, 427, 427, 427, 427
};

const PROGMEM uint16_t BASSLINE_ROCKTWO[16] =
{
  381, 381, 381, 480, 254, 254, 254, 320,
  285, 285, 285, 285, 190, 190, 190, 190
};

//RAM MEMORY TABLE
uint16_t bassline_table[16]   __attribute__ ((aligned(16))) = 
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


#endif
