unsigned long beat_timer = 0;
unsigned long last_time = 0;

int curr_step = 0;
bool kick_steps[16] = {false};
bool snare_steps[16] = {false};
bool hh_steps[16] = {false};
bool tom_steps[16] = {false};

int mode = 0;
int mode_butt_prev = LOW;
bool runnin = false;
bool start_butt_prev = false;
int tempo_prev = 0;

int buttons_timer = 0;

void setup()
{
    //triggers
    pinMode(2, OUTPUT);
    pinMode(3, OUTPUT);
    pinMode(4, OUTPUT);
    pinMode(5, OUTPUT);

    //lights
    pinMode(7, OUTPUT);
    pinMode(6, OUTPUT);
    pinMode(LED_BUILTIN, OUTPUT);
    digitalWrite(LED_BUILTIN, LOW);

    //scanners
    pinMode(8, OUTPUT);
    pinMode(9, OUTPUT);
    pinMode(10, OUTPUT);
    pinMode(11, OUTPUT);

    //buttons
    pinMode(12, INPUT_PULLUP);
    pinMode(A0, INPUT_PULLUP);
    pinMode(A1, INPUT_PULLUP);
    pinMode(A5, INPUT_PULLUP);

    //60,000 / BPM = MS per 4th note
    //our sequencer always counts in 16th notes
    //so our final MS is: 4thMS/4
    //So for 120 BPM this would be: 125 ms = 125000 us
    beat_timer = 125000;
    last_time = micros();

    //set scanners and defaults
    digitalWrite(8, LOW);
    digitalWrite(9, HIGH); //reset
    delay(1);
    digitalWrite(9, LOW);
    digitalWrite(10, LOW);
    digitalWrite(11, HIGH); //reset
    delay(1);
    digitalWrite(11, LOW);

    //lights default
    digitalWrite(7, LOW);
    digitalWrite(6, HIGH);
}

void loop()
{
    if(runnin)
    {
        unsigned long curr_time = micros(); //need to take care of overflow after ~70 minutes
        if(curr_time - last_time > beat_timer)
        {
            last_time = curr_time;

            //set outputs
            digitalWrite(5, kick_steps[curr_step]);
            digitalWrite(2, snare_steps[curr_step]);
            digitalWrite(3, hh_steps[curr_step]);
            digitalWrite(4, tom_steps[curr_step]);

            //step
            curr_step++;
            if(curr_step > 15)
                curr_step = 0;
        }

        //set pins to LOW after 5ms/5000us, to ensure trigger pulse width, regardless of tempo
        curr_time = micros();
        if(curr_time - last_time > 5000)
        {
            digitalWrite(2, LOW);
            digitalWrite(3, LOW);
            digitalWrite(4, LOW);
            digitalWrite(5, LOW);
        }
    }

    //limit amount of scans as a hacky debounce and cpu load reduce
    buttons_timer++;
    if(buttons_timer > 4096)
    {
        //scan tempo 0-1023 mapped to 10-220 BPM, to millisecs, mapped to microsecs
        //((60,000 / BPM) / 4) * 1000
        int temp_tempo = 0;
        if((temp_tempo = analogRead(A4)) != tempo_prev) //quite expensive so lets only do it when changed
        {
            tempo_prev = temp_tempo;
            beat_timer = ((60000 / (long)map(temp_tempo, 0, 1023, 10, 220)) / 4) * 1000;
        }

        //scan START/STOP
        if(analogRead(A0) < 512 && !start_butt_prev)
        {
            runnin = !runnin;
            if(!runnin)
                curr_step = 0; //reset
            start_butt_prev = true;
        }
        else if(analogRead(A0) > 512)
        {
            start_butt_prev = false;
        }

        //scan MODE
        if((temp_tempo = digitalRead(12)) != mode_butt_prev)
        {
            mode++;
            if(mode > 3)
             mode = 0;
             
            mode_butt_prev = temp_tempo;
            
            if(mode == 0)
            {
                digitalWrite(7, LOW);
                digitalWrite(6, LOW);
            }
            else if(mode == 1)
            {
                digitalWrite(7, LOW);
                digitalWrite(6, HIGH);
            }
            else if(mode == 2)
            {
                digitalWrite(7, HIGH);
                digitalWrite(6, LOW);
            }
            else
            {
                digitalWrite(7, HIGH);
                digitalWrite(6, HIGH);
            }
        }

        //scan SOUND SEL
        /*if(analogRead(A5) < 512 && !sel_butt_prev)
        {
        }
        else if(analogRead(A5) > 512)
        {
          
        }*/

        //now scan rhythm switches, when SET/RESET is pressed
        if(analogRead(A1) < 512)
        {
            //digitalWrite(LED_BUILTIN,HIGH);
            //reset both
            digitalWrite(9, HIGH);
            delayMicroseconds(5);
            digitalWrite(9, LOW);

            digitalWrite(11, HIGH);
            delayMicroseconds(5);
            digitalWrite(11, LOW);

            for(int i = 0; i < 8; i++)
            {
                //read out return signal
                if(analogRead(A2) > 64)
                {
                    //1st row button's been set
                    if(mode == 0)
                        kick_steps[i] = true;
                    else if(mode == 1)
                        snare_steps[i] = true;
                    else if(mode == 2)
                        hh_steps[i] = true;
                    else
                        tom_steps[i] = true;
                }
                else
                {
                    if(mode == 0)
                        kick_steps[i] = false;
                    else if(mode == 1)
                        snare_steps[i] = false;
                    else if(mode == 2)
                        hh_steps[i] = false;
                    else
                        tom_steps[i] = false;
                }
                if(analogRead(A3) > 64)
                {
                    //2nd row button's been set
                    if(mode == 0)
                        kick_steps[i + 8] = true;
                    else if(mode == 1)
                        snare_steps[i + 8] = true;
                    else if(mode == 2)
                        hh_steps[i + 8] = true;
                    else
                        tom_steps[i + 8] = true;
                }
                else
                {
                    if(mode == 0)
                        kick_steps[i + 8] = false;
                    else if(mode == 1)
                        snare_steps[i + 8] = false;
                    else if(mode == 2)
                        hh_steps[i + 8] = false;
                    else
                        tom_steps[i + 8] = false;
                }

                //step scanners
                digitalWrite(8, HIGH);
                delayMicroseconds(5);
                digitalWrite(8, LOW);

                digitalWrite(10, HIGH);
                delayMicroseconds(5);
                digitalWrite(10, LOW);
            }
            //digitalWrite(LED_BUILTIN,LOW);
        }
    }
}


