//All hardcoded tables

//FREQ FORMULA:
//(phasecountersize * frequency) / interruptfreq
//(65536 * freq) / 28630
const uint16_t NOTES[] = 
{
  //C0 (extra octave)
  37,40,42,45,47,50,53,56,59,63,67,71,
    
  //C1
  71,75,79,84,89,94,100,106,112,119,126,133,141,

  //C2
  150,159,168,178,189,200,212,224,238,252,267,283,

  //C3
  299,317,336,356,377,400,423,449,475,504,534,565,
  
  //C4
  599,634,672,712,755,799,847,897,951,1007,1067,1131,

  //C5
  1198,1269,1344,1424,1509,1599,1694,1795,1901,2014,2134,2261,

  //C6
  2396,2538,2689,2849,3018,3198,3388,3589,3803,4029,4268,4522,

  //C7
  4791
};

//TABLES **************************************************************************
//wavetables are 256 values long, 64 values deep

//pure square wave, to generate original waveforms
const PROGMEM uint8_t tab_square[256] = 
{
  63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

//extra (bandlimited) waveforms
const PROGMEM uint8_t tab_pulse[256] =
{
  13,23,31,39,46,51,56,59,61,63,63,63,62,61,60,58,56,54,52,50,47,45,43,42,40,38,37,35,34,32,31,30,29,28,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,8,7,6,6,5,5,4,4,4,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const PROGMEM uint8_t tab_saw[256] = 
{
  31,35,39,43,46,48,52,55,58,60,62,62,63,53,52,52,52,52,52,52,51,51,51,50,50,50,49,49,49,48,48,48,48,47,47,47,47,47,46,46,46,46,46,46,45,45,45,45,44,44,44,44,43,43,43,43,42,42,42,42,41,41,41,41,41,40,40,40,40,39,39,39,38,38,38,38,37,37,37,37,36,36,36,36,36,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,33,33,33,33,33,32,32,32,32,31,31,31,30,30,30,29,29,29,28,28,27,27,27,27,26,26,26,26,29,29,28,28,27,28,28,28,27,27,27,28,28,27,27,26,25,25,24,23,23,22,22,21,21,20,20,19,19,19,18,18,17,17,17,16,16,15,15,15,14,14,13,13,13,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,8,8,8,8,8,8,8,7,7,6,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0
};

const PROGMEM uint8_t tab_tri[256] =
{
  0,0,0,0,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,14,14,14,14,14,14,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,18,18,18,19,19,20,20,21,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,39,41,43,45,48,50,53,55,58,60,61,62,63,56,53,53,51,49,47,46,45,44,42,40,39,38,37,36,35,35,34,33,33,32,32,31,30,30,29,29,28,28,28,27,27,26,26,25,25,24,24,23,22,22,21,21,20,19,19,18,18,17,17,16,16,15,15,14,14,13,12,12,11,11,10,10,9,9,9,8,8,7,7,7,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const PROGMEM uint8_t tab_organA[256] =
{
  25,27,32,37,41,42,40,37,33,29,27,27,29,30,32,32,33,34,36,36,36,33,29,23,18,15,14,16,19,23,27,30,34,38,42,45,47,45,42,36,31,28,26,26,27,28,28,29,30,31,32,33,33,30,26,21,18,17,18,22,27,32,38,43,49,54,60,62,63,62,60,56,52,50,49,50,51,52,52,52,53,53,54,52,49,44,38,32,27,25,25,27,30,33,35,38,41,44,46,46,44,40,34,27,22,19,18,17,17,17,17,16,17,17,17,16,13,8,3,3,2,2,2,5,10,15,20,25,25,27,32,37,41,42,40,37,33,29,27,27,29,30,32,32,33,34,36,36,36,33,29,23,18,15,14,16,19,23,27,30,34,38,42,45,47,45,42,36,31,28,26,26,27,28,28,29,30,31,32,33,33,30,26,21,18,17,18,22,27,32,38,43,49,54,60,62,63,62,60,56,52,50,49,50,51,52,52,52,53,53,54,52,49,44,38,32,27,25,25,27,30,33,35,38,41,44,46,46,44,40,34,27,22,19,18,17,17,17,17,16,17,17,17,16,13,8,3,3,2,2,2,5,10,15,20,25
};

const PROGMEM uint8_t tab_organB[256] =
{
  3,5,7,10,12,14,17,19,22,24,26,28,30,32,34,36,37,39,40,41,42,43,44,44,44,44,43,41,39,36,34,33,32,33,34,36,38,41,45,48,50,52,53,52,51,49,46,43,40,38,36,36,37,38,40,42,45,48,51,54,56,58,59,59,59,59,58,57,56,54,52,50,48,45,42,39,36,34,33,32,32,33,35,37,40,44,47,49,51,51,49,46,42,38,34,30,27,26,25,25,25,27,29,31,33,35,36,36,36,35,33,31,28,25,22,19,17,14,12,10,8,6,5,4,3,2,2,2,3,5,7,10,12,14,17,19,22,24,26,28,30,32,34,36,37,39,40,41,42,43,44,44,44,44,43,41,39,36,34,33,32,33,34,36,38,41,45,48,50,52,53,52,51,49,46,43,40,38,36,36,37,38,40,42,45,48,51,54,56,58,59,59,59,59,58,57,56,54,52,50,48,45,42,39,36,34,33,32,32,33,35,37,40,44,47,49,51,51,49,46,42,38,34,30,27,26,25,25,25,27,29,31,33,35,36,36,36,35,33,31,28,25,22,19,17,14,12,10,8,6,5,4,3,2,2,2
};

const PROGMEM uint8_t tab_doublepulse[256] =
{
  0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,16,31,44,51,52,48,41,33,25,19,14,10,8,6,4,4,3,3,2,2,2,2,2,5,13,25,39,53,62,63,60,52,43,33,25,18,13,9,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,13,30,43,48,46,40,33,26,19,14,11,8,6,5,4,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,9,25,44,57,59,54,46,36,27,20,14,10,7,5,4,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0
};

const PROGMEM uint8_t tab_noise[256] =
{
  21,13,9,7,13,9,7,16,21,25,15,24,14,23,14,22,28,32,35,20,29,17,28,34,37,38,41,40,37,36,20,29,35,38,21,31,36,20,30,35,37,38,39,39,39,38,34,29,16,20,24,26,14,22,26,28,28,28,32,37,41,21,31,35,18,26,29,30,31,33,38,43,22,36,41,21,29,32,32,31,29,15,17,10,16,9,18,22,25,28,15,24,13,21,26,14,9,6,4,4,3,3,11,7,12,13,8,5,3,6,4,3,2,2,2,6,8,5,4,14,19,20,26,14,19,11,24,31,2,3,3,6,6,8,8,9,14,16,18,20,21,23,24,25,16,21,23,24,16,20,23,24,16,21,15,12,19,22,15,11,10,9,8,24,16,30,19,13,11,8,26,35,40,22,11,6,4,17,22,23,23,23,12,12,12,6,4,2,9,5,12,13,7,4,10,19,18,23,18,9,5,14,7,14,15,8,5,3,2,11,17,17,9,18,23,18,16,22,13,13,13,22,12,12,7,17,10,13,8,9,13,16,12,14,14,8,6,5,5,8,9,10,10,6,8,5,8,9,7,5,4,3,3,2,2,1
};

//pointer to wavetables
#define WAVETABLESIZE 8
const uint8_t* wavepointers[WAVETABLESIZE] =
{
  tab_square,
  tab_pulse,
  tab_saw,  
  tab_tri,
  tab_organA,
  tab_organB,
  tab_doublepulse,
  tab_noise
};


uint8_t oscAtable[256]   __attribute__ ((aligned(256))) = 
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

uint8_t oscBtable[256]   __attribute__ ((aligned(256))) = 
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


void GenTable(bool oscA, bool oscB)
{  
  if(oscA)
  {
    byte b = 0;
    byte c = 0;
    byte d = 0;
    
    if(PARAMS[1]) //sawtooth mix
    {      
      for(byte a = 0; a != 255; a++, b+=2, c+=4, d+=8)
      {  
          oscAtable[a] = 0;      
          
          if(PARAMS[2]) //16'
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[2]-1][a]);    
          if(PARAMS[3]) //8'
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[3]-1][b]) / 2;
          if(PARAMS[4]) //4'
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[4]-1][c]) / 3;
          if(PARAMS[5]) //2'
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[5]-1][d]) / 4;

          //133 total, just over 128 :(
      }      
    }
    else //square mix
    {
      for(byte a = 0; a != 255; a++, b+=2, c+=4, d+=8)
      {  
          oscAtable[a] = 0;      
          
          if(PARAMS[2])
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[2]-1][a]);          
          if(PARAMS[3])
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[3]-1][b]);
          if(PARAMS[4])
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[4]-1][c]);
          if(PARAMS[5])
            oscAtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[5]-1][d]);

          //256 total, so twice the max :V
          oscAtable[a] >>= 1; //128 now yay
      }
    }
  }

  if(oscB)
  {  
    byte b = 0;
    byte c = 0;
    byte d = 0;
    if(PARAMS[7]) //sawtooth mix
    {      
      for(byte a = 0; a != 255; a++, b+=2, c+=4, d+=8)
      {  
          oscBtable[a] = 0;      
          
          if(PARAMS[8]) //16'
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[8]-1][a]);          
          if(PARAMS[9]) //8'
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[9]-1][b]) / 2;
          if(PARAMS[10]) //4'
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[10]-1][c]) / 3;
          if(PARAMS[11]) //2'
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[11]-1][d]) / 4;
      }
    }
    else //square mix
    {
      for(byte a = 0; a != 255; a++, b+=2, c+=4, d+=8)
      {  
          oscBtable[a] = 0;      
          
          if(PARAMS[8])
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[8]-1][a]);          
          if(PARAMS[9])
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[9]-1][b]);
          if(PARAMS[10])
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[10]-1][c]);
          if(PARAMS[11])
            oscBtable[a] += (uint8_t)pgm_read_byte(&wavepointers[PARAMS[11]-1][d]);

          //256 total, so twice the max :V
          oscBtable[a] >>= 1; //128 now yay
      }
    }
  }
}

//to convert param values to env values
int16_t LINCONV[32] =
{
  128,256,384,512,640,768,896,1024,1152,1280,1408,1536,1664,1792,1920,2047,2175,2303,2431,2559,2687,2815,2943,3071,3199,3327,3455,3583,3711,3839,3967,4095
};

//to convert param values to envelope values, exponentially
int16_t EXPCONV[32] =
{
  4000,2800,1000,500,250,150,120,100,80,70,60,50,36,30,25,18,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1
};
