#include "DCO.h"
#include "tables.h"

//defines
#define OSCS_AMOUNT 8
#define OSCS_AMOUNT_HALF 4

//PORTB
#define DCO_REG1 0
#define DCO_REG2 1
#define DCO_INT 2 //only used by interrupt
#define DCO_WR 3

//globals
DCO oscs[OSCS_AMOUNT];
byte osc_sel = 0;
byte DATA_PREV = 255;
bool env_half = false;
byte DCO1_off = 0;
byte DCO2_off = 0;
byte detune = 0;
byte clockskip = 0;

//functions
void setup() 
{
  MCUCSR = (1<<JTD); //turn JTAG off because of PORTC
  MCUCSR = (1<<JTD); //needs the command twice to work
  
  //DAC ports are outputs
  DDRA = 0b11111111;
  DDRC = 0b11111111;
  PORTA = 0;
  PORTC = 0;

  //control port inputs
  DDRB = 0b00000000;

  //data port inputs
  DDRD = 0b00000000;

  //fill wavetables with basic square FOR TESTING ONLY!
  //for(int i = 0; i < 256; i++)
  //{
  //    oscAtable[i] = (uint8_t)pgm_read_byte(&wavepointers[0][i]) * 8;      
  //    oscBtable[i] = (uint8_t)pgm_read_byte(&wavepointers[0][i]) * 8;
  //}
  
  //setup oscillators with default values
  for(int i = 0; i < OSCS_AMOUNT; i++)
  {
    oscs[i].m_note = 255;
    oscs[i].m_gate = false;
    oscs[i].m_env = 0;
    oscs[i].m_env_stage = 0;
    
    oscs[i].m_amplitude = 0;
    oscs[i].m_freq = 0;
    oscs[i].m_phase = 0;
  }

  //envelope timer
  cli();
  TCCR1A = 0;
  TCCR1B = 0;
  TCNT1  = 0;  
  TCCR1B |= (1 << CS11);    // 8 prescaler 

  //external interrupt clock
  GICR = 1<<INT2;    /* Enable INT2 on PB2*/
  MCUCSR |= 1<<ISC2;  /* Trigger INT2 on rising edge */
  sei();
}

void loop() 
{
  //check for data
  if(PINB & 0b00001000)
  {
    byte DATA = PIND;
    byte REG = PINB & 0b00000011;

    //prevent double read
    if(DATA != DATA_PREV)
    {
      DATA_PREV = DATA;

      //bit 7 is note data
      if(REG == 0b00000011 and DATA & 0b10000000) //note data
      {
        //bit 6 is note on or off
        //remaining 6 bits are note data from C0 to B3
        byte NOTE = DATA & 0b00111111;        

        if(NOTE < 50)
        {
          if(DATA & 0b01000000)
          {
            if(PARAMS[26]) //dual mode
            {
              //check if note exists
              bool found = false;
              for(byte i = 0; i < OSCS_AMOUNT_HALF; i++)
              {
                 if(oscs[i].m_note == NOTE)
                 {
                    found = true;
                    oscs[i].m_gate = true;
                    oscs[i].m_env_stage = 0;
                    oscs[i+OSCS_AMOUNT_HALF].m_gate = true;
                    oscs[i+OSCS_AMOUNT_HALF].m_env_stage = 0;
                    break;
                 }
              }
  
              //doesn't exist play new osc
              if(!found)
              {
                //oh shit, this osc is being used
                byte wrap = 0;
                while(oscs[osc_sel].m_gate)
                {
                  osc_sel++;
                  if(osc_sel == OSCS_AMOUNT_HALF)
                    osc_sel = 0;
  
                  wrap++;
                  if(wrap == OSCS_AMOUNT_HALF)
                    break;
                }
  
                //okay play or steal an osc
                oscs[osc_sel].m_gate = true;
                oscs[osc_sel].m_env_stage = 0;
                oscs[osc_sel].m_note = NOTE;
                oscs[osc_sel].m_freq = NOTES[NOTE+DCO1_off];
                oscs[osc_sel+OSCS_AMOUNT_HALF].m_gate = true;
                oscs[osc_sel+OSCS_AMOUNT_HALF].m_env_stage = 0;                 
                oscs[osc_sel+OSCS_AMOUNT_HALF].m_freq = NOTES[NOTE+DCO2_off];
              }
              
              //increment iterator and loop around
              osc_sel++;
              if(osc_sel == OSCS_AMOUNT_HALF)
                osc_sel = 0;
            }
            else //poly mode
            {
              //check if note exists
              bool found = false;
              for(byte i = 0; i < OSCS_AMOUNT; i++)
              {
                 if(oscs[i].m_note == NOTE)
                 {
                    found = true;
                    oscs[i].m_gate = true;
                    oscs[i].m_env_stage = 0;
                    break;
                 }
              }
  
              //doesn't exist play new osc
              if(!found)
              {
                //oh shit, this osc is being used
                byte wrap = 0;
                while(oscs[osc_sel].m_gate)
                {
                  osc_sel++;
                  if(osc_sel == OSCS_AMOUNT)
                    osc_sel = 0;
  
                  wrap++;
                  if(wrap == OSCS_AMOUNT)
                    break;
                }
  
                //okay play or steal an osc
                oscs[osc_sel].m_gate = true;
                oscs[osc_sel].m_env_stage = 0;
                oscs[osc_sel].m_note = NOTE;
                oscs[osc_sel].m_freq = NOTES[NOTE+DCO1_off];
              }
              
              //increment iterator and loop around
              osc_sel++;
              if(osc_sel == OSCS_AMOUNT)
                osc_sel = 0;
            }
          }
          else //note off
          {
            if(PARAMS[26]) //dual mode
            {
              for(byte i = 0; i < OSCS_AMOUNT_HALF; i++)
              {
                if(oscs[i].m_note == NOTE)
                {
                  oscs[i].m_gate = false;
                  oscs[i+OSCS_AMOUNT_HALF].m_gate = false;
                  break;
                }
              }
            }
            else //poly mode
            {
              for(byte i = 0; i < OSCS_AMOUNT; i++)
              {
                if(oscs[i].m_note == NOTE)
                {
                  oscs[i].m_gate = false;
                  break;
                }
              }
            }
          }
        }
      }
      else //command and param data
      {
        cli();       
        byte ADDR = (REG << 3) + (DATA >> 5);

        if(ADDR == 27) //command
        {
          byte COMMAND = DATA & 0b00011111;

          if(COMMAND == 0) //gen A
            GenTable(true, false);
          else if(COMMAND == 1) //gen B 
            GenTable(false, true);
          else if(COMMAND == 2) //note panic
          {
            for(int i = 0; i < OSCS_AMOUNT; i++)
            {
              oscs[i].m_gate = false;
            }
          }
        }
        else //param
        {
          PARAMS[ADDR] = DATA & 0b00011111;    
          osc_sel = 0;
          DCO1_off = PARAMS[0] * 12; //octave
          DCO2_off = (PARAMS[6] * 12) + PARAMS[12]; //octave + interval

          //detune clockskipper          
          if(!PARAMS[13]) //no detune
          {
            detune = 0;
            clockskip = 1;
          }
          else
            detune = (4-PARAMS[13]) * 64; //3 * 64 = 192 max
            
        }
        
        sei();
      }
    }
  }  

  //process envelopes
  if(TCNT1 > 5000) //~500Hz, 2ms
  {
    TCNT1 = 0;
    env_half = !env_half;

    //process half of the envelopes, makes stuff loop around faster
    if(env_half)
    {
      for(int i = OSCS_AMOUNT_HALF; i < OSCS_AMOUNT; i++)
      {
        if(oscs[i].m_gate)
        {
          if(oscs[i].m_env_stage == 0) //attack
          {
            oscs[i].m_env += EXPCONV[PARAMS[20]];
            if(oscs[i].m_env > 3900)
            {
              oscs[i].m_env = 3900;
              oscs[i].m_env_stage = 1;
            }
          }
          else if(oscs[i].m_env_stage == 1) //decay (to breakpoint)
          {
            oscs[i].m_env -= EXPCONV[PARAMS[21]];
            if(oscs[i].m_env <= LINCONV[PARAMS[22]])
            {
              oscs[i].m_env = LINCONV[PARAMS[22]];
              oscs[i].m_env_stage = 2;
            }
          }
          else if(oscs[i].m_env_stage == 2) //slope (to sustain)
          {
            if(PARAMS[22] <= PARAMS[24])
            {
              oscs[i].m_env += EXPCONV[PARAMS[23]];
              if(oscs[i].m_env > LINCONV[PARAMS[24]])
              {
                oscs[i].m_env = LINCONV[PARAMS[24]];
                oscs[i].m_env_stage = 3;
              }
            }
            else
            {
              oscs[i].m_env -= EXPCONV[PARAMS[23]];
              if(oscs[i].m_env < LINCONV[PARAMS[24]])
              {
                oscs[i].m_env = LINCONV[PARAMS[24]];
                oscs[i].m_env_stage = 3;
              }
            }
          }      
        }
        else //release
        {      
          oscs[i].m_env_stage = 0;
          if(oscs[i].m_env > EXPCONV[PARAMS[25]])
          {
            oscs[i].m_env -= EXPCONV[PARAMS[25]];
          }
          else
          {
            oscs[i].m_env = 0;
            oscs[i].m_note = 255;
          }
        }
  
        oscs[i].m_amplitude = oscs[i].m_env >> 5; //128
      }
    }
    else
    {
      for(int i = 0; i < OSCS_AMOUNT_HALF; i++)
      {
        if(oscs[i].m_gate)
        {
          if(oscs[i].m_env_stage == 0) //attack
          {
            oscs[i].m_env += EXPCONV[PARAMS[14]];
            if(oscs[i].m_env > 3900)
            {
              oscs[i].m_env = 3900;
              oscs[i].m_env_stage = 1;
            }
          }
          else if(oscs[i].m_env_stage == 1) //decay (to breakpoint)
          {
            oscs[i].m_env -= EXPCONV[PARAMS[15]];
            if(oscs[i].m_env < LINCONV[PARAMS[16]])
            {
              oscs[i].m_env = LINCONV[PARAMS[16]];
              oscs[i].m_env_stage = 2;
            }
          }
          else if(oscs[i].m_env_stage == 2) //slope (to sustain)
          {
            if(PARAMS[16] < PARAMS[18])
            {
              oscs[i].m_env += EXPCONV[PARAMS[17]];
              if(oscs[i].m_env > LINCONV[PARAMS[18]])
              {
                oscs[i].m_env = LINCONV[PARAMS[18]];
                oscs[i].m_env_stage = 3;
              }
            }
            else
            {
              oscs[i].m_env -= EXPCONV[PARAMS[17]];
              if(oscs[i].m_env < LINCONV[PARAMS[18]])
              {
                oscs[i].m_env = LINCONV[PARAMS[18]];
                oscs[i].m_env_stage = 3;
              }
            }
          }      
        }
        else //release
        {      
          oscs[i].m_env_stage = 0;
          if(oscs[i].m_env > EXPCONV[PARAMS[19]])
          {
            oscs[i].m_env -= EXPCONV[PARAMS[19]];
          }
          else
          {
            oscs[i].m_env = 0;
            oscs[i].m_note = 255;
          }
        }
  
        oscs[i].m_amplitude = oscs[i].m_env >> 5; //128
      }
    }
  }  
}

//28.63KHz external interrupt, ~35us
//make sure the VCO control voltage is centered at 2.5V!
ISR(INT2_vect)
{  
  uint16_t outvalA = 0;
  uint16_t outvalB = 0;

  //DCO 1
  oscs[0].m_phase += oscs[0].m_freq;  
  outvalA += oscAtable[((uint8_t*)&oscs[0].m_phase)[1]] * oscs[0].m_amplitude;

  oscs[1].m_phase += oscs[1].m_freq;  
  outvalA += oscAtable[((uint8_t*)&oscs[1].m_phase)[1]] * oscs[1].m_amplitude;

  oscs[2].m_phase += oscs[2].m_freq;  
  outvalA += oscAtable[((uint8_t*)&oscs[2].m_phase)[1]] * oscs[2].m_amplitude;

  oscs[3].m_phase += oscs[3].m_freq;  
  outvalA += oscAtable[((uint8_t*)&oscs[3].m_phase)[1]] * oscs[3].m_amplitude;

  //DCO 2
  if(clockskip) //skip is not zero
  {
    oscs[4].m_phase += oscs[4].m_freq;  
    oscs[5].m_phase += oscs[5].m_freq;  
    oscs[6].m_phase += oscs[6].m_freq;  
    oscs[7].m_phase += oscs[7].m_freq;
  }

  if(detune)
  {
    clockskip++;
    if(clockskip > detune)
      clockskip = 0;
  }
  
  outvalB += oscBtable[((uint8_t*)&oscs[4].m_phase)[1]] * oscs[4].m_amplitude;
  outvalB += oscBtable[((uint8_t*)&oscs[5].m_phase)[1]] * oscs[5].m_amplitude;
  outvalB += oscBtable[((uint8_t*)&oscs[6].m_phase)[1]] * oscs[6].m_amplitude;
  outvalB += oscBtable[((uint8_t*)&oscs[7].m_phase)[1]] * oscs[7].m_amplitude;
  
  //write to DAC's =============================================================
  PORTA = ((uint8_t*)&outvalA)[1];
  PORTC = ((uint8_t*)&outvalB)[1];
}
