//all the presets stuff
//banks consist of 8 sections with each 8 values.
//not all values are actually used but this is the easiest way to arrange stuff
//and saves memory
//indexing is ((section-1) * 8) + (value - 1)
//so 18 would become: 7

//\s*//.* to remove comments
//\s* to remove spaces

const PROGMEM byte preset_strings[64] =
{
  2,1,0,1,1,1,16,1,2,1,0,1,1,1,31,0,0,1,0,0,0,0,0,0,22,0,0,1,12,1,0,1,13,31,14,31,31,22,0,0,18,31,31,31,31,20,0,0,7,16,29,25,10,20,0,0,7,6,1,0,0,0,0,0
};

const PROGMEM byte preset_synthebrass[64] =
{
  2,1,1,1,1,1,18,1,2,1,1,1,1,1,12,0,0,1,0,0,0,0,0,0,0,4,1,1,12,0,0,1,6,23,23,31,31,17,0,0,6,22,16,26,0,17,0,0,7,26,23,26,20,16,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_resonantsweep[64] =
{
  2,1,1,1,1,1,16,1,0,1,1,1,1,1,16,0,0,2,0,0,0,0,0,0,9,14,1,1,9,0,0,1,0,31,31,31,31,16,0,0,0,22,31,29,31,19,0,0,24,25,5,28,28,16,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_fatsynthe[64] =
{
  1,1,1,1,1,1,14,1,1,1,1,1,1,1,14,0,0,2,0,0,0,0,0,0,9,2,2,1,12,0,0,1,2,23,20,26,13,15,0,0,7,24,20,24,24,15,0,0,0,0,13,0,31,14,0,0,7,4,0,0,0,0,0,0
};

const PROGMEM byte preset_fullorgan[64] =
{
  1,0,1,1,1,1,14,1,2,0,1,1,1,1,14,0,12,1,0,0,0,0,0,0,23,4,1,1,0,1,0,1,0,31,31,31,31,20,0,0,0,31,31,31,31,20,0,0,0,31,31,31,31,0,0,0,11,0,0,0,0,0,0,0
};

const PROGMEM byte preset_brightpercorgan[64] =
{
  2,0,1,1,0,0,30,1,1,0,0,0,1,1,31,0,7,1,0,0,0,0,0,0,15,12,2,1,0,1,0,1,0,31,31,31,31,1,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,0,0,0,0,0,0
};

const PROGMEM byte preset_lambda[64] =
{
  2,0,0,0,1,0,18,1,2,1,1,1,1,1,10,0,0,1,0,0,0,0,0,0,27,3,1,0,0,1,0,1,0,14,25,25,0,26,0,0,24,23,20,25,14,24,0,0,0,0,0,0,0,12,0,0,7,10,2,0,0,0,0,0
};

const PROGMEM byte preset_sciencebass[64] =
{
  0,1,1,1,1,0,20,1,0,1,1,1,1,1,20,0,0,2,0,0,0,0,0,0,10,4,1,1,6,0,0,0,0,30,26,13,24,19,0,0,1,24,1,27,8,17,0,0,0,16,16,24,0,16,0,0,8,4,1,0,0,0,0,0
};

const PROGMEM byte preset_percpipeorgan[64] =
{
  2,0,1,1,1,1,15,1,2,0,0,1,1,1,15,0,7,0,0,0,0,0,0,0,21,0,0,1,0,0,0,1,0,18,23,28,31,26,0,0,1,23,23,26,24,24,0,0,13,11,26,4,24,0,0,0,7,8,0,0,0,0,0,0
};

const PROGMEM byte preset_syntheflute[64] =
{
  2,1,1,1,1,1,16,1,1,1,1,1,1,1,16,0,0,1,2,0,0,0,0,0,0,6,2,1,6,0,0,1,12,31,23,17,21,17,0,0,6,22,16,27,8,17,0,0,0,6,30,31,0,19,0,0,8,4,2,0,0,0,0,0
};

const PROGMEM byte preset_softpiano[64] =
{
  1,0,0,1,0,0,31,0,1,0,0,1,0,0,31,0,0,0,0,0,0,0,0,0,15,6,0,1,0,1,0,1,1,17,24,26,0,24,0,0,1,17,24,26,0,24,0,0,8,18,0,25,0,0,0,0,4,0,0,0,0,0,0,0
};

const PROGMEM byte preset_chimepiano[64] =
{
  2,0,1,0,0,1,20,2,2,0,1,0,0,1,20,0,0,0,15,0,0,0,0,0,20,0,0,1,1,1,0,1,0,21,22,27,0,24,0,0,1,0,21,22,27,24,0,0,0,0,0,0,0,0,0,0,4,8,1,0,0,0,0,0
};

const PROGMEM byte preset_synthicordi[64] =
{
  1,0,0,0,1,1,15,1,2,1,0,1,1,1,15,0,0,1,0,0,0,0,0,0,31,0,0,1,0,1,0,0,0,24,31,23,0,23,0,0,0,24,17,23,0,23,0,0,0,24,24,22,3,23,0,0,8,0,0,0,0,0,0,0
};

const PROGMEM byte preset_vibes[64] =
{
  2,0,0,1,0,1,31,0,2,0,0,1,0,1,31,0,0,0,0,0,0,0,0,0,19,0,1,1,0,1,0,1,0,16,21,27,0,24,0,0,0,16,21,27,0,24,0,0,0,20,22,24,0,0,0,0,4,8,1,0,0,0,0,0
};

const PROGMEM byte preset_sciencestrings[64] =
{
  1,1,1,1,1,1,12,1,2,1,0,1,1,1,18,0,0,2,0,0,0,0,0,0,21,3,0,1,0,1,0,1,9,31,0,1,27,24,0,0,9,31,14,27,4,22,0,0,0,13,0,0,0,22,0,0,9,0,1,0,0,0,0,0
};

const PROGMEM byte preset_lunarflutes[64] =
{
  2,1,0,1,1,1,31,1,2,1,0,1,1,1,31,0,0,2,0,0,0,0,0,0,14,7,1,1,2,0,0,1,20,18,19,15,21,25,0,0,19,19,20,15,21,25,0,0,12,21,13,14,21,15,0,0,6,0,2,0,0,0,0,0
};

const PROGMEM byte preset_1999[64] =
{
  2,1,1,1,1,1,10,1,2,0,1,1,1,1,12,0,0,2,0,0,0,0,0,0,7,2,0,1,9,1,0,1,0,31,23,17,25,17,0,0,2,23,16,27,31,17,0,0,0,6,30,31,31,19,0,0,7,4,1,0,0,0,0,0
};

const PROGMEM byte preset_obcross[64] =
{
  2,1,1,1,0,0,10,1,2,1,1,1,1,1,10,0,0,2,15,0,0,0,0,0,22,1,1,0,0,1,0,1,0,23,0,0,0,24,0,0,0,28,0,0,0,23,0,0,7,0,7,25,10,23,0,0,7,4,0,0,0,0,0,0
};

//PLACEHOLDER
const PROGMEM byte preset_placeholder[64] =
{
  1,0,1,0,0,0,31,0,1,0,1,0,0,0,31,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,30,30,30,30,30,30,0,0,30,30,30,30,30,30,0,0,30,30,30,30,30,30,0,0,1,0,0,0,0,0,0,0
};

const PROGMEM byte preset_percsynthe[64] =
{
  1,1,1,1,1,0,30,0,1,1,1,1,1,0,30,0,0,0,0,0,0,0,0,0,7,7,0,1,9,1,0,1,0,20,20,27,27,0,0,0,0,22,14,27,4,14,0,0,0,20,15,31,24,0,0,0,8,0,0,0,0,0,0,0
};

const PROGMEM byte preset_mutedbrass[64] =
{
  1,1,1,1,1,1,16,1,1,1,1,1,1,1,16,0,0,2,0,0,0,0,0,0,0,0,1,1,10,0,0,1,0,23,23,31,31,17,0,0,0,22,16,27,0,17,0,0,11,24,22,26,18,20,0,0,7,0,0,0,0,0,0,0
};

const PROGMEM byte preset_organupper[64] =
{
  3,0,1,1,0,0,30,1,2,0,0,0,1,1,30,0,7,0,0,0,0,0,0,0,20,8,1,1,0,2,0,1,0,26,31,20,31,1,0,0,0,17,24,9,12,0,0,0,0,0,0,0,31,0,0,0,7,0,0,0,0,0,0,0
};

const PROGMEM byte preset_resosynthe[64] =
{
  1,1,1,1,1,1,20,1,1,1,1,1,1,1,20,0,0,1,0,0,0,0,0,0,5,10,0,1,9,1,0,1,0,15,22,26,20,17,0,0,8,15,16,19,31,20,0,0,0,24,15,0,13,22,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_8notebrass[64] =
{
  2,1,1,1,1,1,14,0,2,1,1,1,1,1,14,0,0,0,0,0,0,0,0,0,1,0,0,1,12,0,0,1,6,27,23,28,31,16,0,0,0,27,23,28,31,16,0,0,13,11,26,26,20,18,0,0,7,8,2,0,0,0,0,0
};

const PROGMEM byte preset_honkykeys[64] =
{
  2,1,1,1,1,1,24,1,2,1,1,1,1,1,12,0,0,3,0,0,0,0,0,0,20,8,0,0,0,0,0,1,0,22,18,26,0,14,0,0,0,24,14,28,4,14,0,0,7,16,20,25,10,30,0,0,4,0,0,0,0,0,0,0
};

const PROGMEM byte preset_synthicordii[64] =
{
  0,0,0,0,1,1,18,1,1,1,0,1,1,1,18,0,0,2,0,0,0,0,0,0,30,5,0,1,0,1,0,1,0,24,31,23,8,19,0,0,0,24,17,23,16,19,0,0,0,24,24,22,3,20,0,0,9,6,0,0,0,0,0,0
};

const PROGMEM byte preset_steeldrums[64] =
{
  1,0,0,1,0,0,31,1,2,0,0,1,0,0,12,0,9,3,8,0,0,0,0,0,20,0,1,1,0,0,0,1,0,15,22,25,0,21,0,0,0,22,1,26,0,22,0,0,0,11,10,25,0,21,0,0,6,5,2,0,0,0,0,0
};

const PROGMEM byte preset_synthebassi[64] =
{
  1,0,1,1,0,0,14,1,2,1,1,1,1,1,14,0,0,2,0,0,0,0,0,0,11,0,0,1,6,1,0,1,0,22,20,23,0,19,0,0,0,15,16,19,0,18,0,0,0,19,14,25,0,24,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_synthebassiii[64] =
{
  1,1,1,1,1,1,12,1,2,1,1,1,1,1,12,0,0,2,0,0,0,0,0,0,10,0,0,1,6,1,0,1,0,26,23,26,0,20,0,0,0,16,16,19,0,20,0,0,0,19,14,25,0,20,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_wetones[64] =
{
  0,1,1,1,1,1,24,1,1,1,1,1,1,1,24,0,0,2,0,0,0,0,0,0,24,13,1,0,4,1,0,1,0,26,31,0,0,9,0,0,0,15,21,16,31,8,0,0,0,19,9,11,0,0,0,0,7,4,0,0,0,0,0,0
};

const PROGMEM byte preset_echosynthe[64] =
{
  1,1,1,1,1,1,20,1,1,1,1,1,1,1,20,0,0,2,0,0,0,0,0,0,6,10,0,1,9,1,0,1,0,15,22,26,20,17,0,0,8,15,16,19,31,20,0,0,0,16,0,0,18,22,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_blackhole[64] =
{
  0,1,1,1,1,1,16,1,0,1,1,1,1,1,16,0,6,3,0,0,0,0,0,0,30,3,1,0,15,1,0,1,30,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,6,0,0,0,21,0,0,8,4,0,0,0,0,0,0
};

const PROGMEM byte preset_synfuleyes[64] =
{
  2,1,1,1,0,0,10,1,2,1,1,1,1,1,10,0,0,2,15,0,0,0,0,0,29,1,2,0,3,1,0,1,0,20,0,0,0,24,0,0,7,28,0,0,0,24,0,0,7,0,7,26,10,24,0,0,7,4,1,0,0,0,0,0
};

//PARAMS array
byte PARAMS[64] = {0};
const byte PARAM_LIMITS[64] =
{
  2, //0 DCO1 octave
  1, //1 DCO1 "waveform" i.e. mix
  8, //2 DCO1 16'
  8, //3 DCO1 8'
  8, //4 DCO1 4'
  8, //5 DCO1 2'
  31, //6 DCO1 level
  1, //7 poly or double
  2, //8 DCO2 octave
  1, //9 DCO2 "waveform" i.e. mix
  8, //10 DCO2 16'
  8, //11 DCO2 8'
  8, //12 DCO2 4'
  8, //13 DCO2 2'
  31, //14 DCO2 level
  0, //15 
  12, //16 DCO2 interval
  3, //17 DCO2 detune
  15, //18 noise level
  0, //19
  0, //20
  0, //21
  0, //22
  0, //23
  31, //24 cutoff
  15, //25 resonance
  2, //26 key track
  1, //27 env polarity
  15, //28 env depth
  1, //29 trigger
  0,
  1, //31 chorus mode
  31, //32 eg1 attack
  31, //33 eg1 decay
  31, //34 eg1 breakpoint
  31, //35 eg1 slope
  31, //36 eg1 sustain
  31, //37 eg1 release
  0, //38 
  0, //39 
  31, //40 eg2 attack
  31, //41 eg2 decay
  31, //42 eg2 breakpoint
  31, //43 eg2 slope
  31, //44 eg2 sustain
  31, //45 eg2 release
  0, //46
  0, //47
  31, //48 eg3 attack
  31, //49 eg3 decay
  31, //50 eg3 breakpoint
  31, //51 eg3 slope
  31, //52 eg3 sustain
  31, //53 eg3 release
  0, //54
  0, //55
  15, //56 MG freq
  15, //57 MG delay
  15, //58 MG vib depth
  15, //59 MG vcf depth
  0, //60
  1, //61 MIDI recieve channel
  1, //62 MIDI prog change enable
  1  //63 seq clock int or ext
};

const byte* FACTORYPRESETS[32] = 
{
  //4 banks of Korg preset sounds
  //bank 1: strings, brass, harder stuff
  preset_strings,       //11
  preset_sciencestrings,//44
  preset_fatsynthe,     //18
  preset_1999,          //24
  preset_obcross,       //32
  preset_synthebrass,   //13
  preset_percsynthe,    //21
  preset_mutedbrass,    //22
  
  //bank 2: organs, softer pads and strings
  preset_fullorgan,     //17
  preset_brightpercorgan,//27
  preset_percpipeorgan, //82
  preset_organupper,    //63
  preset_lunarflutes,   //83
  preset_syntheflute,   //52   
  preset_resosynthe,    //75
  preset_8notebrass,    //71
  
  //bank 3: pianos, harpsichords, vibes, etc
  preset_softpiano,     //65
  preset_chimepiano,    //57
  preset_honkykeys,     //72
  preset_synthicordi,   //53
  preset_synthicordii,  //54
  preset_lambda,        //31
  preset_vibes,         //85  
  preset_steeldrums,    //68
  
  //bank 4: basses and wierd shit prolly
  preset_sciencebass,     //28
  preset_synthebassi,     //35
  preset_synthebassiii,   //84
  preset_resonantsweep,   //15
  preset_wetones,         //43
  preset_echosynthe,      //76
  preset_blackhole,       //77  
  preset_synfuleyes,      //42
};

byte ParamToIndex(byte param)
{
  byte bank = param / 10;
  byte value = param % 10;
  return ((bank-1) * 8) + (value-1);
}

void SendDCOData(byte addr, byte data)
{
  PORTD &= 0b11100111; //clear register select pins
  PORTD |= addr & 0b00011000; //set register select
  PORTC = addr << 5; //set address
  PORTC |= data;     //set data
  SET(PORTD, DCO_WR);
  DELAY_CYCLES(400);
  CLR(PORTD, DCO_WR);
}

void LoadPreset(byte prst)
{
  cli();
  byte ind = ParamToIndex(prst);
  for(byte i = 0; i < 64; i++)
  {
    PARAMS[i] = (byte)pgm_read_byte(&FACTORYPRESETS[ind][i]);                
  }

  //CHORUS=======================================
  if(PARAMS[31])
    CLR(PORTA, CHOR_EN);
  else
    SET(PORTA, CHOR_EN);

  //TODO: speed and depth pins, once I've wired that up :)


  //DCO ==========================================
  SendDCOData(27, 2); //command, NOTE PANIC
  DELAY_CYCLES(1000); //extra delay, in case
  //DCO1
  SendDCOData(0, PARAMS[0]);
  SendDCOData(1, PARAMS[1]);
  SendDCOData(2, PARAMS[2]);
  SendDCOData(3, PARAMS[3]);
  SendDCOData(4, PARAMS[4]);
  SendDCOData(5, PARAMS[5]);

  //DCO2
  SendDCOData(6, PARAMS[8]);
  SendDCOData(7, PARAMS[9]);
  SendDCOData(8, PARAMS[10]);
  SendDCOData(9, PARAMS[11]);
  SendDCOData(10, PARAMS[12]);
  SendDCOData(11, PARAMS[13]);

  SendDCOData(12, PARAMS[16]); //interval
  SendDCOData(13, PARAMS[17]); //detune

  //ENV1
  SendDCOData(14, PARAMS[32]);
  SendDCOData(15, PARAMS[33]);
  SendDCOData(16, PARAMS[34]);
  SendDCOData(17, PARAMS[35]);
  SendDCOData(18, PARAMS[36]);
  SendDCOData(19, PARAMS[37]);

  //ENV2
  SendDCOData(20, PARAMS[40]);
  SendDCOData(21, PARAMS[41]);
  SendDCOData(22, PARAMS[42]);
  SendDCOData(23, PARAMS[43]);
  SendDCOData(24, PARAMS[44]);
  SendDCOData(25, PARAMS[45]);

  SendDCOData(26, PARAMS[7]); //poly/double mode

  SendDCOData(27, 0); //command, GENTABLES
  DELAY_CYCLES(8000);
  SendDCOData(27, 1); //command, GENTABLES
  DELAY_CYCLES(8000);
  sei();
}

void LoadPresetEEPROM(byte prst)
{
  
}
