#include"SevenSegment.h"

/*
#define RESET     10
#define PIN_MOSI  11
#define PIN_MISO  12
#define PIN_SCK   13
*/

/*
TODO:
- param serial send to DUE 
- Do something with pin 28 (PC5/ADC5) on the atmega, maybe a LED indicator or an (analog) input?
 */

#define SQK_VERSION 03

#define KNOBS_RETURN A0
#define KNOBS3 11       //PB3
#define KNOBS2 12       //PB4
#define KNOBS1 13       //BP5
#define KNOBS_SELA 8
#define KNOBS_SELB 9

#define BEND_WHEEL A3
#define MODU_WHEEL A2
#define SLIDER     A1
#define AFTERTOUCH A4

byte uservals[4] = {0}; //slider, bend, mod, aft
byte knobvals[16] = {0};
byte knobcounter = 0;

//serial interface
//should send the following:
// > 127 for current param change, send once per change
// < 127 for current param value
bool paramchange = false;
bool valuechange = false;
byte lastvalue = 0;
byte lastparam = 0;

SQK_SEVSEG sevseg;

void setup() 
{
  sevseg.begin();
  Serial.begin(9600);

  pinMode(KNOBS_RETURN, INPUT);
  analogRead(KNOBS_RETURN); //setup analog input
  pinMode(KNOBS1, OUTPUT);
  pinMode(KNOBS2, OUTPUT);
  pinMode(KNOBS3, OUTPUT);

  sevseg.setChar(CHAR_S);
  sevseg.setNum(SQK_VERSION);
}

void loop() 
{
  //PARAM CHANGE SYSTEM*************************************
  if(valuechange and Serial.availableForWrite() > 1) //ensure 2 bytes
  {
    valuechange = false;

    if(paramchange)
    {
      paramchange = false;

      Serial.write(lastparam+128); //params are > 127
    }
    
    Serial.write(lastvalue);
  }
  else //don't do other stuff when serial is updating
  {
    //FRONT PANEL READOUTS************************************
    //scan pitch, mod, etc
    byte temp = map(analogRead(SLIDER), 0, 1023, 0, 64);
    if(temp != uservals[0])
    {
      uservals[0] = temp;
      sevseg.setChar(CHAR_S);
      sevseg.setNum(temp);

      if(lastparam != 34)
      {
        lastparam = 34;
        paramchange = true;
      }
      valuechange = true;
      lastvalue = temp;
    }
  
    temp = map(analogRead(BEND_WHEEL), 384, 608, 64, 0);
    if(temp != uservals[1])
    {
      uservals[1] = temp;
      sevseg.setChar(CHAR_B);
      sevseg.setNum(temp);

      if(lastparam != 35)
      {
        lastparam = 35;
        paramchange = true;
      }
      valuechange = true;
      lastvalue = temp;
    }
  
    temp = map(analogRead(MODU_WHEEL), 400, 624, 0, 64);
    if(temp != uservals[2])
    {
      uservals[2] = temp;
      sevseg.setChar(CHAR_N);
      sevseg.setNum(temp);

      if(lastparam != 36)
      {
        lastparam = 36;
        paramchange = true;
      }
      valuechange = true;
      lastvalue = temp;
    }
  
    /*temp = map(analogRead(AFTERTOUCH), 0, 1023, 0, 64);
    if(temp != uservals[3])
    {
      uservals[3] = temp;
      sevseg.setChar(CHAR_A);
      sevseg.setNum(temp);

      if(lastparam != 165)
      {
        lastparam = 165;
        paramchange = true;
      }
      valuechange = true;
      lastvalue = temp;
    }*/
    
    //scan knobs ******************
    knobcounter++;
    if(knobcounter > 7)
      knobcounter = 0;
    
    //scan bottom row
    CLR(PORTB, 0); //A
    
    {
      if(bitRead(knobcounter,0))
        SET(PORTB, 5);
      else
        CLR(PORTB, 5);
  
      if(bitRead(knobcounter,1))
        SET(PORTB, 4);
      else
        CLR(PORTB, 4);
  
      if(bitRead(knobcounter,2))
        SET(PORTB, 3);
      else
        CLR(PORTB, 3);
      
      temp = (byte)map(analogRead(KNOBS_RETURN), 0, 1023, 0, 64);
      if(temp != knobvals[knobcounter]) //knob value has changed since last time!
      {
        knobvals[knobcounter] = temp;
        sevseg.setChar(CHAR_P);
        sevseg.setNum(temp);

        if(knobcounter != lastparam)
        {
          lastparam = knobcounter;
          paramchange = true;
        }
        valuechange = true;
        lastvalue = temp;
      }
    }
  
    SET(PORTB, 0); //A
  
    //scan upper row
    CLR(PORTB, 1); //1
    
    {
      if(bitRead(knobcounter,0))
        SET(PORTB, 5);
      else
        CLR(PORTB, 5);
  
      if(bitRead(knobcounter,1))
        SET(PORTB, 4);
      else
        CLR(PORTB, 4);
  
      if(bitRead(knobcounter,2))
        SET(PORTB, 3);
      else
        CLR(PORTB, 3);
      
      byte temp = (byte)map(analogRead(KNOBS_RETURN), 0, 1023, 0, 64);
      byte knoboffset = knobcounter + 8;
      if(temp != knobvals[knoboffset]) //knob value has changed since last time!
      {
        knobvals[knoboffset] = temp;
        sevseg.setChar(CHAR_P);
        sevseg.setNum(temp);

        if(knoboffset != lastparam)
        {
          lastparam = knoboffset;
          paramchange = true;
        }
        valuechange = true;
        lastvalue = temp;
      }
    }
  
    SET(PORTB, 1); //B
  
    sevseg.refresh();
  }
}

