
#ifndef _SEVENSEG_H
#define _SEVENSEG_H

#define SEGA 0      //PORTB
#define SEGB 1      //PORTB
#define SEGC 2      //PORTB

#define SEG1 6  //a    //PORTB     aaa
#define SEG2 7  //b    //PORTB   f     b
#define SEG3 3  //c    //PORTD   f     b
#define SEG4 4  //d    //PORTD     ggg
#define SEG5 5  //e    //PORTD   e     c
#define SEG6 6  //f    //PORTD   e     c
#define SEG7 7  //g    //PORTD     ddd
#define SEG8 2  //dot  //PORTD

//Port manipulation macros
#define SET(x,y)(x|=(1<<y))
#define CLR(x,y)(x&=(~(1<<y)))

//character indexes
#define NUM_CHARS 13
#define CHAR_A 11
#define CHAR_P 12
#define CHAR_S 6 //same as 5
#define CHAR_B 9 //same as 8
#define CHAR_N 13 //wierd one but ah well

byte dispdigits[] =
{
  //keep in mind this is two ports
  //abcdefg.  
  0b00000000, //nothing
  0b11011110,  //0
  0b10000010,  //1
  0b11101100,  //2
  0b11100110,  //3
  0b10110010,  //4
  0b01110110,  //5
  0b01111110,  //6
  0b11000010,  //7
  0b11111110,  //8
  0b11110110,  //9
  0b11111010,  //A
  0b11111000,  //P
  0b11011010  //N, sorta
};

class SQK_SEVSEG
{
private:
  byte dispval;
  byte charval;

public:
  SQK_SEVSEG()
  { }

  ~SQK_SEVSEG()
  { }

  void begin()
  {
    dispval = 0;
    charval = 0;

    pinMode(8, OUTPUT);
    pinMode(9, OUTPUT);
    pinMode(10, OUTPUT);
  
    pinMode(20, OUTPUT);
    pinMode(21, OUTPUT);
    pinMode(3, OUTPUT);
    pinMode(4, OUTPUT);
    pinMode(5, OUTPUT);
    pinMode(6, OUTPUT);
    pinMode(7, OUTPUT);
    pinMode(2, OUTPUT);

    digitalWrite(8, HIGH);
    digitalWrite(9, HIGH);
    digitalWrite(10, HIGH);

    digitalWrite(20, HIGH);
    digitalWrite(21, HIGH);
    digitalWrite(3, HIGH);
    digitalWrite(4, HIGH);
    digitalWrite(5, HIGH);
    digitalWrite(6, HIGH);
    digitalWrite(7, HIGH);
    digitalWrite(2, HIGH);
  }

  void setNum(byte num)
  {
    dispval = constrain(num, 0, 63);
  }

  void setChar(byte ch)
  {
    charval = constrain(ch, 0, NUM_CHARS);
  }

  void refresh()
  {
    //set pins at the same time |= 0b00000011
    //clear pins at the same time &= ~(0b00000011)
    //to be selective i could just AND the digit value i.e. (0b01100101 & 0b11110000) etc
    //mind that this is active LOW

    /*
     Given the number 12345 :
    5 is 12345 % 10
    4 is 12345 / 10 % 10
    3 is 12345 / 100 % 10
    2 is 12345 / 1000 % 10
    1 is 12345 / 10000 % 10
     * 
     */

    //third digit
    CLR(PORTB, SEGC);

    byte tempval = (dispval % 10) + 1;
    PORTB &= ~(dispdigits[tempval] & 0b11000000);
    PORTD &= ~(dispdigits[tempval]<<2 & 0b11111000);  

    delayMicroseconds(20);
    PORTB |= (dispdigits[tempval] & 0b11000000);
    PORTD |= (dispdigits[tempval]<<2 & 0b11111000);

    SET(PORTB, SEGC);

    //second digit, tens
    CLR(PORTB, SEGB);

    tempval = (dispval / 10 % 10) + 1;
    PORTB &= ~(dispdigits[tempval] & 0b11000000);
    PORTD &= ~(dispdigits[tempval]<<2 & 0b11111000);  

    delayMicroseconds(20);
    PORTB |= (dispdigits[tempval] & 0b11000000);
    PORTD |= (dispdigits[tempval]<<2 & 0b11111000);

    SET(PORTB, SEGB);

    //********************************************************
    //first digit, number to indicate value category
    CLR(PORTB, SEGA);

    PORTB &= ~(dispdigits[charval] & 0b11000000);
    PORTD &= ~(dispdigits[charval]<<2 & 0b11111000);  

    delayMicroseconds(20);
    PORTB |= (dispdigits[charval] & 0b11000000);
    PORTD |= (dispdigits[charval]<<2 & 0b11111000);

    SET(PORTB, SEGA);
  }
  
};


#endif

